/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MigrationValidationDatabaseSummaryResult;
import com.azure.resourcemanager.datamigration.models.ValidationStatus;
import java.io.IOException;
import java.util.Map;

public class MigrationValidationResult
implements JsonSerializable<MigrationValidationResult> {
    private String id;
    private String migrationId;
    private Map<String, MigrationValidationDatabaseSummaryResult> summaryResults;
    private ValidationStatus status;

    public String id() {
        return this.id;
    }

    MigrationValidationResult withId(String id) {
        this.id = id;
        return this;
    }

    public String migrationId() {
        return this.migrationId;
    }

    MigrationValidationResult withMigrationId(String migrationId) {
        this.migrationId = migrationId;
        return this;
    }

    public Map<String, MigrationValidationDatabaseSummaryResult> summaryResults() {
        return this.summaryResults;
    }

    public MigrationValidationResult withSummaryResults(Map<String, MigrationValidationDatabaseSummaryResult> summaryResults) {
        this.summaryResults = summaryResults;
        return this;
    }

    public ValidationStatus status() {
        return this.status;
    }

    MigrationValidationResult withStatus(ValidationStatus status) {
        this.status = status;
        return this;
    }

    public void validate() {
        if (this.summaryResults() != null) {
            this.summaryResults().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("summaryResults", this.summaryResults, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MigrationValidationResult fromJson(JsonReader jsonReader) throws IOException {
        return (MigrationValidationResult)jsonReader.readObject(reader -> {
            MigrationValidationResult deserializedMigrationValidationResult = new MigrationValidationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMigrationValidationResult.id = reader.getString();
                    continue;
                }
                if ("migrationId".equals(fieldName)) {
                    deserializedMigrationValidationResult.migrationId = reader.getString();
                    continue;
                }
                if ("summaryResults".equals(fieldName)) {
                    Map summaryResults;
                    deserializedMigrationValidationResult.summaryResults = summaryResults = reader.readMap(reader1 -> MigrationValidationDatabaseSummaryResult.fromJson(reader1));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedMigrationValidationResult.status = ValidationStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrationValidationResult;
        });
    }
}

