/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.SqlBackupSetInfo;
import java.io.IOException;
import java.util.List;

public final class MigrationStatusDetails
implements JsonSerializable<MigrationStatusDetails> {
    private String migrationState;
    private SqlBackupSetInfo fullBackupSetInfo;
    private SqlBackupSetInfo lastRestoredBackupSetInfo;
    private List<SqlBackupSetInfo> activeBackupSets;
    private List<String> invalidFiles;
    private String blobContainerName;
    private Boolean isFullBackupRestored;
    private String restoreBlockingReason;
    private String completeRestoreErrorMessage;
    private List<String> fileUploadBlockingErrors;
    private String currentRestoringFilename;
    private String lastRestoredFilename;
    private Integer pendingLogBackupsCount;

    public String migrationState() {
        return this.migrationState;
    }

    public SqlBackupSetInfo fullBackupSetInfo() {
        return this.fullBackupSetInfo;
    }

    public SqlBackupSetInfo lastRestoredBackupSetInfo() {
        return this.lastRestoredBackupSetInfo;
    }

    public List<SqlBackupSetInfo> activeBackupSets() {
        return this.activeBackupSets;
    }

    public List<String> invalidFiles() {
        return this.invalidFiles;
    }

    public String blobContainerName() {
        return this.blobContainerName;
    }

    public Boolean isFullBackupRestored() {
        return this.isFullBackupRestored;
    }

    public String restoreBlockingReason() {
        return this.restoreBlockingReason;
    }

    public String completeRestoreErrorMessage() {
        return this.completeRestoreErrorMessage;
    }

    public List<String> fileUploadBlockingErrors() {
        return this.fileUploadBlockingErrors;
    }

    public String currentRestoringFilename() {
        return this.currentRestoringFilename;
    }

    public String lastRestoredFilename() {
        return this.lastRestoredFilename;
    }

    public Integer pendingLogBackupsCount() {
        return this.pendingLogBackupsCount;
    }

    public void validate() {
        if (this.fullBackupSetInfo() != null) {
            this.fullBackupSetInfo().validate();
        }
        if (this.lastRestoredBackupSetInfo() != null) {
            this.lastRestoredBackupSetInfo().validate();
        }
        if (this.activeBackupSets() != null) {
            this.activeBackupSets().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static MigrationStatusDetails fromJson(JsonReader jsonReader) throws IOException {
        return (MigrationStatusDetails)jsonReader.readObject(reader -> {
            MigrationStatusDetails deserializedMigrationStatusDetails = new MigrationStatusDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("migrationState".equals(fieldName)) {
                    deserializedMigrationStatusDetails.migrationState = reader.getString();
                    continue;
                }
                if ("fullBackupSetInfo".equals(fieldName)) {
                    deserializedMigrationStatusDetails.fullBackupSetInfo = SqlBackupSetInfo.fromJson(reader);
                    continue;
                }
                if ("lastRestoredBackupSetInfo".equals(fieldName)) {
                    deserializedMigrationStatusDetails.lastRestoredBackupSetInfo = SqlBackupSetInfo.fromJson(reader);
                    continue;
                }
                if ("activeBackupSets".equals(fieldName)) {
                    List activeBackupSets;
                    deserializedMigrationStatusDetails.activeBackupSets = activeBackupSets = reader.readArray(reader1 -> SqlBackupSetInfo.fromJson(reader1));
                    continue;
                }
                if ("invalidFiles".equals(fieldName)) {
                    List invalidFiles;
                    deserializedMigrationStatusDetails.invalidFiles = invalidFiles = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("blobContainerName".equals(fieldName)) {
                    deserializedMigrationStatusDetails.blobContainerName = reader.getString();
                    continue;
                }
                if ("isFullBackupRestored".equals(fieldName)) {
                    deserializedMigrationStatusDetails.isFullBackupRestored = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("restoreBlockingReason".equals(fieldName)) {
                    deserializedMigrationStatusDetails.restoreBlockingReason = reader.getString();
                    continue;
                }
                if ("completeRestoreErrorMessage".equals(fieldName)) {
                    deserializedMigrationStatusDetails.completeRestoreErrorMessage = reader.getString();
                    continue;
                }
                if ("fileUploadBlockingErrors".equals(fieldName)) {
                    List fileUploadBlockingErrors;
                    deserializedMigrationStatusDetails.fileUploadBlockingErrors = fileUploadBlockingErrors = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("currentRestoringFilename".equals(fieldName)) {
                    deserializedMigrationStatusDetails.currentRestoringFilename = reader.getString();
                    continue;
                }
                if ("lastRestoredFilename".equals(fieldName)) {
                    deserializedMigrationStatusDetails.lastRestoredFilename = reader.getString();
                    continue;
                }
                if ("pendingLogBackupsCount".equals(fieldName)) {
                    deserializedMigrationStatusDetails.pendingLogBackupsCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrationStatusDetails;
        });
    }
}

