/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.SqlConnectionInfo;
import com.azure.resourcemanager.datamigration.models.SqlMigrationTaskInput;
import com.azure.resourcemanager.datamigration.models.SsisMigrationInfo;
import java.io.IOException;

public final class MigrateSsisTaskInput
extends SqlMigrationTaskInput {
    private SsisMigrationInfo ssisMigrationInfo;
    private static final ClientLogger LOGGER = new ClientLogger(MigrateSsisTaskInput.class);

    public SsisMigrationInfo ssisMigrationInfo() {
        return this.ssisMigrationInfo;
    }

    public MigrateSsisTaskInput withSsisMigrationInfo(SsisMigrationInfo ssisMigrationInfo) {
        this.ssisMigrationInfo = ssisMigrationInfo;
        return this;
    }

    @Override
    public MigrateSsisTaskInput withSourceConnectionInfo(SqlConnectionInfo sourceConnectionInfo) {
        super.withSourceConnectionInfo(sourceConnectionInfo);
        return this;
    }

    @Override
    public MigrateSsisTaskInput withTargetConnectionInfo(SqlConnectionInfo targetConnectionInfo) {
        super.withTargetConnectionInfo(targetConnectionInfo);
        return this;
    }

    @Override
    public void validate() {
        if (this.ssisMigrationInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ssisMigrationInfo in model MigrateSsisTaskInput"));
        }
        this.ssisMigrationInfo().validate();
        if (this.sourceConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceConnectionInfo in model MigrateSsisTaskInput"));
        }
        this.sourceConnectionInfo().validate();
        if (this.targetConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetConnectionInfo in model MigrateSsisTaskInput"));
        }
        this.targetConnectionInfo().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceConnectionInfo", (JsonSerializable)this.sourceConnectionInfo());
        jsonWriter.writeJsonField("targetConnectionInfo", (JsonSerializable)this.targetConnectionInfo());
        jsonWriter.writeJsonField("ssisMigrationInfo", (JsonSerializable)this.ssisMigrationInfo);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSsisTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSsisTaskInput)jsonReader.readObject(reader -> {
            MigrateSsisTaskInput deserializedMigrateSsisTaskInput = new MigrateSsisTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceConnectionInfo".equals(fieldName)) {
                    deserializedMigrateSsisTaskInput.withSourceConnectionInfo(SqlConnectionInfo.fromJson(reader));
                    continue;
                }
                if ("targetConnectionInfo".equals(fieldName)) {
                    deserializedMigrateSsisTaskInput.withTargetConnectionInfo(SqlConnectionInfo.fromJson(reader));
                    continue;
                }
                if ("ssisMigrationInfo".equals(fieldName)) {
                    deserializedMigrateSsisTaskInput.ssisMigrationInfo = SsisMigrationInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSsisTaskInput;
        });
    }
}

