/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.fluent.models.CommandPropertiesInner;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlMITaskInput;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlMITaskOutput;
import com.azure.resourcemanager.datamigration.models.ProjectTaskProperties;
import com.azure.resourcemanager.datamigration.models.TaskState;
import com.azure.resourcemanager.datamigration.models.TaskType;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class MigrateSqlServerSqlMITaskProperties
extends ProjectTaskProperties {
    private TaskType taskType = TaskType.MIGRATE_SQL_SERVER_AZURE_SQL_DB_MI;
    private MigrateSqlServerSqlMITaskInput input;
    private List<MigrateSqlServerSqlMITaskOutput> output;
    private String taskId;
    private String createdOn;
    private String parentTaskId;
    private Boolean isCloneable;

    @Override
    public TaskType taskType() {
        return this.taskType;
    }

    public MigrateSqlServerSqlMITaskInput input() {
        return this.input;
    }

    public MigrateSqlServerSqlMITaskProperties withInput(MigrateSqlServerSqlMITaskInput input) {
        this.input = input;
        return this;
    }

    public List<MigrateSqlServerSqlMITaskOutput> output() {
        return this.output;
    }

    public String taskId() {
        return this.taskId;
    }

    public MigrateSqlServerSqlMITaskProperties withTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public String createdOn() {
        return this.createdOn;
    }

    public MigrateSqlServerSqlMITaskProperties withCreatedOn(String createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    public String parentTaskId() {
        return this.parentTaskId;
    }

    public MigrateSqlServerSqlMITaskProperties withParentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
        return this;
    }

    public Boolean isCloneable() {
        return this.isCloneable;
    }

    public MigrateSqlServerSqlMITaskProperties withIsCloneable(Boolean isCloneable) {
        this.isCloneable = isCloneable;
        return this;
    }

    @Override
    public MigrateSqlServerSqlMITaskProperties withClientData(Map<String, String> clientData) {
        super.withClientData(clientData);
        return this;
    }

    @Override
    public void validate() {
        if (this.input() != null) {
            this.input().validate();
        }
        if (this.output() != null) {
            this.output().forEach(e -> e.validate());
        }
        if (this.commands() != null) {
            this.commands().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("clientData", this.clientData(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("taskType", this.taskType == null ? null : this.taskType.toString());
        jsonWriter.writeJsonField("input", (JsonSerializable)this.input);
        jsonWriter.writeStringField("taskId", this.taskId);
        jsonWriter.writeStringField("createdOn", this.createdOn);
        jsonWriter.writeStringField("parentTaskId", this.parentTaskId);
        jsonWriter.writeBooleanField("isCloneable", this.isCloneable);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSqlServerSqlMITaskProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSqlServerSqlMITaskProperties)jsonReader.readObject(reader -> {
            MigrateSqlServerSqlMITaskProperties deserializedMigrateSqlServerSqlMITaskProperties = new MigrateSqlServerSqlMITaskProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errors".equals(fieldName)) {
                    List errors = reader.readArray(reader1 -> ManagementError.fromJson((JsonReader)reader1));
                    deserializedMigrateSqlServerSqlMITaskProperties.withErrors(errors);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskProperties.withState(TaskState.fromString(reader.getString()));
                    continue;
                }
                if ("commands".equals(fieldName)) {
                    List commands = reader.readArray(reader1 -> CommandPropertiesInner.fromJson(reader1));
                    deserializedMigrateSqlServerSqlMITaskProperties.withCommands(commands);
                    continue;
                }
                if ("clientData".equals(fieldName)) {
                    Map clientData = reader.readMap(reader1 -> reader1.getString());
                    deserializedMigrateSqlServerSqlMITaskProperties.withClientData(clientData);
                    continue;
                }
                if ("taskType".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskProperties.taskType = TaskType.fromString(reader.getString());
                    continue;
                }
                if ("input".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskProperties.input = MigrateSqlServerSqlMITaskInput.fromJson(reader);
                    continue;
                }
                if ("output".equals(fieldName)) {
                    List output;
                    deserializedMigrateSqlServerSqlMITaskProperties.output = output = reader.readArray(reader1 -> MigrateSqlServerSqlMITaskOutput.fromJson(reader1));
                    continue;
                }
                if ("taskId".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskProperties.taskId = reader.getString();
                    continue;
                }
                if ("createdOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskProperties.createdOn = reader.getString();
                    continue;
                }
                if ("parentTaskId".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskProperties.parentTaskId = reader.getString();
                    continue;
                }
                if ("isCloneable".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskProperties.isCloneable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSqlServerSqlMITaskProperties;
        });
    }
}

