/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlMITaskOutput;
import com.azure.resourcemanager.datamigration.models.MigrationState;
import com.azure.resourcemanager.datamigration.models.ReportableException;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class MigrateSqlServerSqlMITaskOutputAgentJobLevel
extends MigrateSqlServerSqlMITaskOutput {
    private String resultType = "AgentJobLevelOutput";
    private String name;
    private Boolean isEnabled;
    private MigrationState state;
    private OffsetDateTime startedOn;
    private OffsetDateTime endedOn;
    private String message;
    private List<ReportableException> exceptionsAndWarnings;

    @Override
    public String resultType() {
        return this.resultType;
    }

    public String name() {
        return this.name;
    }

    public Boolean isEnabled() {
        return this.isEnabled;
    }

    public MigrationState state() {
        return this.state;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    public String message() {
        return this.message;
    }

    public List<ReportableException> exceptionsAndWarnings() {
        return this.exceptionsAndWarnings;
    }

    @Override
    public void validate() {
        if (this.exceptionsAndWarnings() != null) {
            this.exceptionsAndWarnings().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultType", this.resultType);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSqlServerSqlMITaskOutputAgentJobLevel fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSqlServerSqlMITaskOutputAgentJobLevel)jsonReader.readObject(reader -> {
            MigrateSqlServerSqlMITaskOutputAgentJobLevel deserializedMigrateSqlServerSqlMITaskOutputAgentJobLevel = new MigrateSqlServerSqlMITaskOutputAgentJobLevel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputAgentJobLevel.withId(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputAgentJobLevel.resultType = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputAgentJobLevel.name = reader.getString();
                    continue;
                }
                if ("isEnabled".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputAgentJobLevel.isEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputAgentJobLevel.state = MigrationState.fromString(reader.getString());
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputAgentJobLevel.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputAgentJobLevel.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputAgentJobLevel.message = reader.getString();
                    continue;
                }
                if ("exceptionsAndWarnings".equals(fieldName)) {
                    List exceptionsAndWarnings;
                    deserializedMigrateSqlServerSqlMITaskOutputAgentJobLevel.exceptionsAndWarnings = exceptionsAndWarnings = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSqlServerSqlMITaskOutputAgentJobLevel;
        });
    }
}

