/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.BackupMode;
import com.azure.resourcemanager.datamigration.models.BlobShare;
import com.azure.resourcemanager.datamigration.models.FileShare;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlMIDatabaseInput;
import com.azure.resourcemanager.datamigration.models.SqlConnectionInfo;
import com.azure.resourcemanager.datamigration.models.SqlMigrationTaskInput;
import java.io.IOException;
import java.util.List;

public final class MigrateSqlServerSqlMITaskInput
extends SqlMigrationTaskInput {
    private List<MigrateSqlServerSqlMIDatabaseInput> selectedDatabases;
    private String startedOn;
    private List<String> selectedLogins;
    private List<String> selectedAgentJobs;
    private FileShare backupFileShare;
    private BlobShare backupBlobShare;
    private BackupMode backupMode;
    private String aadDomainName;
    private String encryptedKeyForSecureFields;
    private static final ClientLogger LOGGER = new ClientLogger(MigrateSqlServerSqlMITaskInput.class);

    public List<MigrateSqlServerSqlMIDatabaseInput> selectedDatabases() {
        return this.selectedDatabases;
    }

    public MigrateSqlServerSqlMITaskInput withSelectedDatabases(List<MigrateSqlServerSqlMIDatabaseInput> selectedDatabases) {
        this.selectedDatabases = selectedDatabases;
        return this;
    }

    public String startedOn() {
        return this.startedOn;
    }

    public MigrateSqlServerSqlMITaskInput withStartedOn(String startedOn) {
        this.startedOn = startedOn;
        return this;
    }

    public List<String> selectedLogins() {
        return this.selectedLogins;
    }

    public MigrateSqlServerSqlMITaskInput withSelectedLogins(List<String> selectedLogins) {
        this.selectedLogins = selectedLogins;
        return this;
    }

    public List<String> selectedAgentJobs() {
        return this.selectedAgentJobs;
    }

    public MigrateSqlServerSqlMITaskInput withSelectedAgentJobs(List<String> selectedAgentJobs) {
        this.selectedAgentJobs = selectedAgentJobs;
        return this;
    }

    public FileShare backupFileShare() {
        return this.backupFileShare;
    }

    public MigrateSqlServerSqlMITaskInput withBackupFileShare(FileShare backupFileShare) {
        this.backupFileShare = backupFileShare;
        return this;
    }

    public BlobShare backupBlobShare() {
        return this.backupBlobShare;
    }

    public MigrateSqlServerSqlMITaskInput withBackupBlobShare(BlobShare backupBlobShare) {
        this.backupBlobShare = backupBlobShare;
        return this;
    }

    public BackupMode backupMode() {
        return this.backupMode;
    }

    public MigrateSqlServerSqlMITaskInput withBackupMode(BackupMode backupMode) {
        this.backupMode = backupMode;
        return this;
    }

    public String aadDomainName() {
        return this.aadDomainName;
    }

    public MigrateSqlServerSqlMITaskInput withAadDomainName(String aadDomainName) {
        this.aadDomainName = aadDomainName;
        return this;
    }

    public String encryptedKeyForSecureFields() {
        return this.encryptedKeyForSecureFields;
    }

    public MigrateSqlServerSqlMITaskInput withEncryptedKeyForSecureFields(String encryptedKeyForSecureFields) {
        this.encryptedKeyForSecureFields = encryptedKeyForSecureFields;
        return this;
    }

    @Override
    public MigrateSqlServerSqlMITaskInput withSourceConnectionInfo(SqlConnectionInfo sourceConnectionInfo) {
        super.withSourceConnectionInfo(sourceConnectionInfo);
        return this;
    }

    @Override
    public MigrateSqlServerSqlMITaskInput withTargetConnectionInfo(SqlConnectionInfo targetConnectionInfo) {
        super.withTargetConnectionInfo(targetConnectionInfo);
        return this;
    }

    @Override
    public void validate() {
        if (this.selectedDatabases() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property selectedDatabases in model MigrateSqlServerSqlMITaskInput"));
        }
        this.selectedDatabases().forEach(e -> e.validate());
        if (this.backupFileShare() != null) {
            this.backupFileShare().validate();
        }
        if (this.backupBlobShare() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property backupBlobShare in model MigrateSqlServerSqlMITaskInput"));
        }
        this.backupBlobShare().validate();
        if (this.sourceConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceConnectionInfo in model MigrateSqlServerSqlMITaskInput"));
        }
        this.sourceConnectionInfo().validate();
        if (this.targetConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetConnectionInfo in model MigrateSqlServerSqlMITaskInput"));
        }
        this.targetConnectionInfo().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceConnectionInfo", (JsonSerializable)this.sourceConnectionInfo());
        jsonWriter.writeJsonField("targetConnectionInfo", (JsonSerializable)this.targetConnectionInfo());
        jsonWriter.writeArrayField("selectedDatabases", this.selectedDatabases, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("backupBlobShare", (JsonSerializable)this.backupBlobShare);
        jsonWriter.writeStringField("startedOn", this.startedOn);
        jsonWriter.writeArrayField("selectedLogins", this.selectedLogins, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("selectedAgentJobs", this.selectedAgentJobs, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("backupFileShare", (JsonSerializable)this.backupFileShare);
        jsonWriter.writeStringField("backupMode", this.backupMode == null ? null : this.backupMode.toString());
        jsonWriter.writeStringField("aadDomainName", this.aadDomainName);
        jsonWriter.writeStringField("encryptedKeyForSecureFields", this.encryptedKeyForSecureFields);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSqlServerSqlMITaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSqlServerSqlMITaskInput)jsonReader.readObject(reader -> {
            MigrateSqlServerSqlMITaskInput deserializedMigrateSqlServerSqlMITaskInput = new MigrateSqlServerSqlMITaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceConnectionInfo".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskInput.withSourceConnectionInfo(SqlConnectionInfo.fromJson(reader));
                    continue;
                }
                if ("targetConnectionInfo".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskInput.withTargetConnectionInfo(SqlConnectionInfo.fromJson(reader));
                    continue;
                }
                if ("selectedDatabases".equals(fieldName)) {
                    List selectedDatabases;
                    deserializedMigrateSqlServerSqlMITaskInput.selectedDatabases = selectedDatabases = reader.readArray(reader1 -> MigrateSqlServerSqlMIDatabaseInput.fromJson(reader1));
                    continue;
                }
                if ("backupBlobShare".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskInput.backupBlobShare = BlobShare.fromJson(reader);
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskInput.startedOn = reader.getString();
                    continue;
                }
                if ("selectedLogins".equals(fieldName)) {
                    List selectedLogins;
                    deserializedMigrateSqlServerSqlMITaskInput.selectedLogins = selectedLogins = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("selectedAgentJobs".equals(fieldName)) {
                    List selectedAgentJobs;
                    deserializedMigrateSqlServerSqlMITaskInput.selectedAgentJobs = selectedAgentJobs = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("backupFileShare".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskInput.backupFileShare = FileShare.fromJson(reader);
                    continue;
                }
                if ("backupMode".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskInput.backupMode = BackupMode.fromString(reader.getString());
                    continue;
                }
                if ("aadDomainName".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskInput.aadDomainName = reader.getString();
                    continue;
                }
                if ("encryptedKeyForSecureFields".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskInput.encryptedKeyForSecureFields = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSqlServerSqlMITaskInput;
        });
    }
}

