/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlMISyncTaskOutput;
import com.azure.resourcemanager.datamigration.models.MigrationState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class MigrateSqlServerSqlMISyncTaskOutputMigrationLevel
extends MigrateSqlServerSqlMISyncTaskOutput {
    private String resultType = "MigrationLevelOutput";
    private Integer databaseCount;
    private MigrationState state;
    private OffsetDateTime startedOn;
    private OffsetDateTime endedOn;
    private String sourceServerName;
    private String sourceServerVersion;
    private String sourceServerBrandVersion;
    private String targetServerName;
    private String targetServerVersion;
    private String targetServerBrandVersion;
    private Integer databaseErrorCount;

    @Override
    public String resultType() {
        return this.resultType;
    }

    public Integer databaseCount() {
        return this.databaseCount;
    }

    public MigrationState state() {
        return this.state;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    public String sourceServerName() {
        return this.sourceServerName;
    }

    public String sourceServerVersion() {
        return this.sourceServerVersion;
    }

    public String sourceServerBrandVersion() {
        return this.sourceServerBrandVersion;
    }

    public String targetServerName() {
        return this.targetServerName;
    }

    public String targetServerVersion() {
        return this.targetServerVersion;
    }

    public String targetServerBrandVersion() {
        return this.targetServerBrandVersion;
    }

    public Integer databaseErrorCount() {
        return this.databaseErrorCount;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultType", this.resultType);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSqlServerSqlMISyncTaskOutputMigrationLevel fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSqlServerSqlMISyncTaskOutputMigrationLevel)jsonReader.readObject(reader -> {
            MigrateSqlServerSqlMISyncTaskOutputMigrationLevel deserializedMigrateSqlServerSqlMISyncTaskOutputMigrationLevel = new MigrateSqlServerSqlMISyncTaskOutputMigrationLevel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputMigrationLevel.withId(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputMigrationLevel.resultType = reader.getString();
                    continue;
                }
                if ("databaseCount".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputMigrationLevel.databaseCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputMigrationLevel.state = MigrationState.fromString(reader.getString());
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputMigrationLevel.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputMigrationLevel.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("sourceServerName".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputMigrationLevel.sourceServerName = reader.getString();
                    continue;
                }
                if ("sourceServerVersion".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputMigrationLevel.sourceServerVersion = reader.getString();
                    continue;
                }
                if ("sourceServerBrandVersion".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputMigrationLevel.sourceServerBrandVersion = reader.getString();
                    continue;
                }
                if ("targetServerName".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputMigrationLevel.targetServerName = reader.getString();
                    continue;
                }
                if ("targetServerVersion".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputMigrationLevel.targetServerVersion = reader.getString();
                    continue;
                }
                if ("targetServerBrandVersion".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputMigrationLevel.targetServerBrandVersion = reader.getString();
                    continue;
                }
                if ("databaseErrorCount".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputMigrationLevel.databaseErrorCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSqlServerSqlMISyncTaskOutputMigrationLevel;
        });
    }
}

