/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.FileShare;
import java.io.IOException;
import java.util.List;

public final class MigrateSqlServerSqlMIDatabaseInput
implements JsonSerializable<MigrateSqlServerSqlMIDatabaseInput> {
    private String name;
    private String restoreDatabaseName;
    private FileShare backupFileShare;
    private List<String> backupFilePaths;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(MigrateSqlServerSqlMIDatabaseInput.class);

    public String name() {
        return this.name;
    }

    public MigrateSqlServerSqlMIDatabaseInput withName(String name) {
        this.name = name;
        return this;
    }

    public String restoreDatabaseName() {
        return this.restoreDatabaseName;
    }

    public MigrateSqlServerSqlMIDatabaseInput withRestoreDatabaseName(String restoreDatabaseName) {
        this.restoreDatabaseName = restoreDatabaseName;
        return this;
    }

    public FileShare backupFileShare() {
        return this.backupFileShare;
    }

    public MigrateSqlServerSqlMIDatabaseInput withBackupFileShare(FileShare backupFileShare) {
        this.backupFileShare = backupFileShare;
        return this;
    }

    public List<String> backupFilePaths() {
        return this.backupFilePaths;
    }

    public MigrateSqlServerSqlMIDatabaseInput withBackupFilePaths(List<String> backupFilePaths) {
        this.backupFilePaths = backupFilePaths;
        return this;
    }

    public String id() {
        return this.id;
    }

    public MigrateSqlServerSqlMIDatabaseInput withId(String id) {
        this.id = id;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model MigrateSqlServerSqlMIDatabaseInput"));
        }
        if (this.restoreDatabaseName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property restoreDatabaseName in model MigrateSqlServerSqlMIDatabaseInput"));
        }
        if (this.backupFileShare() != null) {
            this.backupFileShare().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("restoreDatabaseName", this.restoreDatabaseName);
        jsonWriter.writeJsonField("backupFileShare", (JsonSerializable)this.backupFileShare);
        jsonWriter.writeArrayField("backupFilePaths", this.backupFilePaths, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSqlServerSqlMIDatabaseInput fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSqlServerSqlMIDatabaseInput)jsonReader.readObject(reader -> {
            MigrateSqlServerSqlMIDatabaseInput deserializedMigrateSqlServerSqlMIDatabaseInput = new MigrateSqlServerSqlMIDatabaseInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMIDatabaseInput.name = reader.getString();
                    continue;
                }
                if ("restoreDatabaseName".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMIDatabaseInput.restoreDatabaseName = reader.getString();
                    continue;
                }
                if ("backupFileShare".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMIDatabaseInput.backupFileShare = FileShare.fromJson(reader);
                    continue;
                }
                if ("backupFilePaths".equals(fieldName)) {
                    List backupFilePaths;
                    deserializedMigrateSqlServerSqlMIDatabaseInput.backupFilePaths = backupFilePaths = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMIDatabaseInput.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSqlServerSqlMIDatabaseInput;
        });
    }
}

