/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlDbTaskOutput;
import com.azure.resourcemanager.datamigration.models.MigrationState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class MigrateSqlServerSqlDbTaskOutputTableLevel
extends MigrateSqlServerSqlDbTaskOutput {
    private String resultType = "TableLevelOutput";
    private String objectName;
    private OffsetDateTime startedOn;
    private OffsetDateTime endedOn;
    private MigrationState state;
    private String statusMessage;
    private Long itemsCount;
    private Long itemsCompletedCount;
    private String errorPrefix;
    private String resultPrefix;

    @Override
    public String resultType() {
        return this.resultType;
    }

    public String objectName() {
        return this.objectName;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    public MigrationState state() {
        return this.state;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Long itemsCount() {
        return this.itemsCount;
    }

    public Long itemsCompletedCount() {
        return this.itemsCompletedCount;
    }

    public String errorPrefix() {
        return this.errorPrefix;
    }

    public String resultPrefix() {
        return this.resultPrefix;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultType", this.resultType);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSqlServerSqlDbTaskOutputTableLevel fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSqlServerSqlDbTaskOutputTableLevel)jsonReader.readObject(reader -> {
            MigrateSqlServerSqlDbTaskOutputTableLevel deserializedMigrateSqlServerSqlDbTaskOutputTableLevel = new MigrateSqlServerSqlDbTaskOutputTableLevel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputTableLevel.withId(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputTableLevel.resultType = reader.getString();
                    continue;
                }
                if ("objectName".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputTableLevel.objectName = reader.getString();
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputTableLevel.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputTableLevel.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputTableLevel.state = MigrationState.fromString(reader.getString());
                    continue;
                }
                if ("statusMessage".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputTableLevel.statusMessage = reader.getString();
                    continue;
                }
                if ("itemsCount".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputTableLevel.itemsCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("itemsCompletedCount".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputTableLevel.itemsCompletedCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("errorPrefix".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputTableLevel.errorPrefix = reader.getString();
                    continue;
                }
                if ("resultPrefix".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputTableLevel.resultPrefix = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSqlServerSqlDbTaskOutputTableLevel;
        });
    }
}

