/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlDbSyncTaskOutput;
import com.azure.resourcemanager.datamigration.models.SyncTableMigrationState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class MigrateSqlServerSqlDbSyncTaskOutputTableLevel
extends MigrateSqlServerSqlDbSyncTaskOutput {
    private String resultType = "TableLevelOutput";
    private String tableName;
    private String databaseName;
    private Long cdcInsertCounter;
    private Long cdcUpdateCounter;
    private Long cdcDeleteCounter;
    private OffsetDateTime fullLoadEstFinishTime;
    private OffsetDateTime fullLoadStartedOn;
    private OffsetDateTime fullLoadEndedOn;
    private Long fullLoadTotalRows;
    private SyncTableMigrationState state;
    private Long totalChangesApplied;
    private Long dataErrorsCounter;
    private OffsetDateTime lastModifiedTime;

    @Override
    public String resultType() {
        return this.resultType;
    }

    public String tableName() {
        return this.tableName;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public Long cdcInsertCounter() {
        return this.cdcInsertCounter;
    }

    public Long cdcUpdateCounter() {
        return this.cdcUpdateCounter;
    }

    public Long cdcDeleteCounter() {
        return this.cdcDeleteCounter;
    }

    public OffsetDateTime fullLoadEstFinishTime() {
        return this.fullLoadEstFinishTime;
    }

    public OffsetDateTime fullLoadStartedOn() {
        return this.fullLoadStartedOn;
    }

    public OffsetDateTime fullLoadEndedOn() {
        return this.fullLoadEndedOn;
    }

    public Long fullLoadTotalRows() {
        return this.fullLoadTotalRows;
    }

    public SyncTableMigrationState state() {
        return this.state;
    }

    public Long totalChangesApplied() {
        return this.totalChangesApplied;
    }

    public Long dataErrorsCounter() {
        return this.dataErrorsCounter;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultType", this.resultType);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSqlServerSqlDbSyncTaskOutputTableLevel fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSqlServerSqlDbSyncTaskOutputTableLevel)jsonReader.readObject(reader -> {
            MigrateSqlServerSqlDbSyncTaskOutputTableLevel deserializedMigrateSqlServerSqlDbSyncTaskOutputTableLevel = new MigrateSqlServerSqlDbSyncTaskOutputTableLevel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputTableLevel.withId(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputTableLevel.resultType = reader.getString();
                    continue;
                }
                if ("tableName".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputTableLevel.tableName = reader.getString();
                    continue;
                }
                if ("databaseName".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputTableLevel.databaseName = reader.getString();
                    continue;
                }
                if ("cdcInsertCounter".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputTableLevel.cdcInsertCounter = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("cdcUpdateCounter".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputTableLevel.cdcUpdateCounter = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("cdcDeleteCounter".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputTableLevel.cdcDeleteCounter = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("fullLoadEstFinishTime".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputTableLevel.fullLoadEstFinishTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("fullLoadStartedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputTableLevel.fullLoadStartedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("fullLoadEndedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputTableLevel.fullLoadEndedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("fullLoadTotalRows".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputTableLevel.fullLoadTotalRows = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputTableLevel.state = SyncTableMigrationState.fromString(reader.getString());
                    continue;
                }
                if ("totalChangesApplied".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputTableLevel.totalChangesApplied = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("dataErrorsCounter".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputTableLevel.dataErrorsCounter = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputTableLevel.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSqlServerSqlDbSyncTaskOutputTableLevel;
        });
    }
}

