/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.fluent.models.CommandPropertiesInner;
import com.azure.resourcemanager.datamigration.models.MigrateSchemaSqlServerSqlDbTaskInput;
import com.azure.resourcemanager.datamigration.models.MigrateSchemaSqlServerSqlDbTaskOutput;
import com.azure.resourcemanager.datamigration.models.ProjectTaskProperties;
import com.azure.resourcemanager.datamigration.models.TaskState;
import com.azure.resourcemanager.datamigration.models.TaskType;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class MigrateSchemaSqlServerSqlDbTaskProperties
extends ProjectTaskProperties {
    private TaskType taskType = TaskType.MIGRATE_SCHEMA_SQL_SERVER_SQL_DB;
    private MigrateSchemaSqlServerSqlDbTaskInput input;
    private List<MigrateSchemaSqlServerSqlDbTaskOutput> output;
    private String createdOn;
    private String taskId;
    private Boolean isCloneable;

    @Override
    public TaskType taskType() {
        return this.taskType;
    }

    public MigrateSchemaSqlServerSqlDbTaskInput input() {
        return this.input;
    }

    public MigrateSchemaSqlServerSqlDbTaskProperties withInput(MigrateSchemaSqlServerSqlDbTaskInput input) {
        this.input = input;
        return this;
    }

    public List<MigrateSchemaSqlServerSqlDbTaskOutput> output() {
        return this.output;
    }

    public String createdOn() {
        return this.createdOn;
    }

    public MigrateSchemaSqlServerSqlDbTaskProperties withCreatedOn(String createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    public String taskId() {
        return this.taskId;
    }

    public MigrateSchemaSqlServerSqlDbTaskProperties withTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public Boolean isCloneable() {
        return this.isCloneable;
    }

    public MigrateSchemaSqlServerSqlDbTaskProperties withIsCloneable(Boolean isCloneable) {
        this.isCloneable = isCloneable;
        return this;
    }

    @Override
    public MigrateSchemaSqlServerSqlDbTaskProperties withClientData(Map<String, String> clientData) {
        super.withClientData(clientData);
        return this;
    }

    @Override
    public void validate() {
        if (this.input() != null) {
            this.input().validate();
        }
        if (this.output() != null) {
            this.output().forEach(e -> e.validate());
        }
        if (this.commands() != null) {
            this.commands().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("clientData", this.clientData(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("taskType", this.taskType == null ? null : this.taskType.toString());
        jsonWriter.writeJsonField("input", (JsonSerializable)this.input);
        jsonWriter.writeStringField("createdOn", this.createdOn);
        jsonWriter.writeStringField("taskId", this.taskId);
        jsonWriter.writeBooleanField("isCloneable", this.isCloneable);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSchemaSqlServerSqlDbTaskProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSchemaSqlServerSqlDbTaskProperties)jsonReader.readObject(reader -> {
            MigrateSchemaSqlServerSqlDbTaskProperties deserializedMigrateSchemaSqlServerSqlDbTaskProperties = new MigrateSchemaSqlServerSqlDbTaskProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errors".equals(fieldName)) {
                    List errors = reader.readArray(reader1 -> ManagementError.fromJson((JsonReader)reader1));
                    deserializedMigrateSchemaSqlServerSqlDbTaskProperties.withErrors(errors);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMigrateSchemaSqlServerSqlDbTaskProperties.withState(TaskState.fromString(reader.getString()));
                    continue;
                }
                if ("commands".equals(fieldName)) {
                    List commands = reader.readArray(reader1 -> CommandPropertiesInner.fromJson(reader1));
                    deserializedMigrateSchemaSqlServerSqlDbTaskProperties.withCommands(commands);
                    continue;
                }
                if ("clientData".equals(fieldName)) {
                    Map clientData = reader.readMap(reader1 -> reader1.getString());
                    deserializedMigrateSchemaSqlServerSqlDbTaskProperties.withClientData(clientData);
                    continue;
                }
                if ("taskType".equals(fieldName)) {
                    deserializedMigrateSchemaSqlServerSqlDbTaskProperties.taskType = TaskType.fromString(reader.getString());
                    continue;
                }
                if ("input".equals(fieldName)) {
                    deserializedMigrateSchemaSqlServerSqlDbTaskProperties.input = MigrateSchemaSqlServerSqlDbTaskInput.fromJson(reader);
                    continue;
                }
                if ("output".equals(fieldName)) {
                    List output;
                    deserializedMigrateSchemaSqlServerSqlDbTaskProperties.output = output = reader.readArray(reader1 -> MigrateSchemaSqlServerSqlDbTaskOutput.fromJson(reader1));
                    continue;
                }
                if ("createdOn".equals(fieldName)) {
                    deserializedMigrateSchemaSqlServerSqlDbTaskProperties.createdOn = reader.getString();
                    continue;
                }
                if ("taskId".equals(fieldName)) {
                    deserializedMigrateSchemaSqlServerSqlDbTaskProperties.taskId = reader.getString();
                    continue;
                }
                if ("isCloneable".equals(fieldName)) {
                    deserializedMigrateSchemaSqlServerSqlDbTaskProperties.isCloneable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSchemaSqlServerSqlDbTaskProperties;
        });
    }
}

