/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.fluent.models.CommandPropertiesInner;
import com.azure.resourcemanager.datamigration.models.MigrateOracleAzureDbPostgreSqlSyncTaskInput;
import com.azure.resourcemanager.datamigration.models.MigrateOracleAzureDbPostgreSqlSyncTaskOutput;
import com.azure.resourcemanager.datamigration.models.ProjectTaskProperties;
import com.azure.resourcemanager.datamigration.models.TaskState;
import com.azure.resourcemanager.datamigration.models.TaskType;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class MigrateOracleAzureDbForPostgreSqlSyncTaskProperties
extends ProjectTaskProperties {
    private TaskType taskType = TaskType.MIGRATE_ORACLE_AZURE_DB_FOR_POSTGRE_SQL_SYNC;
    private MigrateOracleAzureDbPostgreSqlSyncTaskInput input;
    private List<MigrateOracleAzureDbPostgreSqlSyncTaskOutput> output;

    @Override
    public TaskType taskType() {
        return this.taskType;
    }

    public MigrateOracleAzureDbPostgreSqlSyncTaskInput input() {
        return this.input;
    }

    public MigrateOracleAzureDbForPostgreSqlSyncTaskProperties withInput(MigrateOracleAzureDbPostgreSqlSyncTaskInput input) {
        this.input = input;
        return this;
    }

    public List<MigrateOracleAzureDbPostgreSqlSyncTaskOutput> output() {
        return this.output;
    }

    @Override
    public MigrateOracleAzureDbForPostgreSqlSyncTaskProperties withClientData(Map<String, String> clientData) {
        super.withClientData(clientData);
        return this;
    }

    @Override
    public void validate() {
        if (this.input() != null) {
            this.input().validate();
        }
        if (this.output() != null) {
            this.output().forEach(e -> e.validate());
        }
        if (this.commands() != null) {
            this.commands().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("clientData", this.clientData(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("taskType", this.taskType == null ? null : this.taskType.toString());
        jsonWriter.writeJsonField("input", (JsonSerializable)this.input);
        return jsonWriter.writeEndObject();
    }

    public static MigrateOracleAzureDbForPostgreSqlSyncTaskProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateOracleAzureDbForPostgreSqlSyncTaskProperties)jsonReader.readObject(reader -> {
            MigrateOracleAzureDbForPostgreSqlSyncTaskProperties deserializedMigrateOracleAzureDbForPostgreSqlSyncTaskProperties = new MigrateOracleAzureDbForPostgreSqlSyncTaskProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errors".equals(fieldName)) {
                    List errors = reader.readArray(reader1 -> ManagementError.fromJson((JsonReader)reader1));
                    deserializedMigrateOracleAzureDbForPostgreSqlSyncTaskProperties.withErrors(errors);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMigrateOracleAzureDbForPostgreSqlSyncTaskProperties.withState(TaskState.fromString(reader.getString()));
                    continue;
                }
                if ("commands".equals(fieldName)) {
                    List commands = reader.readArray(reader1 -> CommandPropertiesInner.fromJson(reader1));
                    deserializedMigrateOracleAzureDbForPostgreSqlSyncTaskProperties.withCommands(commands);
                    continue;
                }
                if ("clientData".equals(fieldName)) {
                    Map clientData = reader.readMap(reader1 -> reader1.getString());
                    deserializedMigrateOracleAzureDbForPostgreSqlSyncTaskProperties.withClientData(clientData);
                    continue;
                }
                if ("taskType".equals(fieldName)) {
                    deserializedMigrateOracleAzureDbForPostgreSqlSyncTaskProperties.taskType = TaskType.fromString(reader.getString());
                    continue;
                }
                if ("input".equals(fieldName)) {
                    deserializedMigrateOracleAzureDbForPostgreSqlSyncTaskProperties.input = MigrateOracleAzureDbPostgreSqlSyncTaskInput.fromJson(reader);
                    continue;
                }
                if ("output".equals(fieldName)) {
                    List output;
                    deserializedMigrateOracleAzureDbForPostgreSqlSyncTaskProperties.output = output = reader.readArray(reader1 -> MigrateOracleAzureDbPostgreSqlSyncTaskOutput.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateOracleAzureDbForPostgreSqlSyncTaskProperties;
        });
    }
}

