/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.fluent.models.CommandPropertiesInner;
import com.azure.resourcemanager.datamigration.models.InstallOciDriverTaskInput;
import com.azure.resourcemanager.datamigration.models.InstallOciDriverTaskOutput;
import com.azure.resourcemanager.datamigration.models.ProjectTaskProperties;
import com.azure.resourcemanager.datamigration.models.TaskState;
import com.azure.resourcemanager.datamigration.models.TaskType;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class InstallOciDriverTaskProperties
extends ProjectTaskProperties {
    private TaskType taskType = TaskType.SERVICE_INSTALL_OCI;
    private InstallOciDriverTaskInput input;
    private List<InstallOciDriverTaskOutput> output;

    @Override
    public TaskType taskType() {
        return this.taskType;
    }

    public InstallOciDriverTaskInput input() {
        return this.input;
    }

    public InstallOciDriverTaskProperties withInput(InstallOciDriverTaskInput input) {
        this.input = input;
        return this;
    }

    public List<InstallOciDriverTaskOutput> output() {
        return this.output;
    }

    @Override
    public InstallOciDriverTaskProperties withClientData(Map<String, String> clientData) {
        super.withClientData(clientData);
        return this;
    }

    @Override
    public void validate() {
        if (this.input() != null) {
            this.input().validate();
        }
        if (this.output() != null) {
            this.output().forEach(e -> e.validate());
        }
        if (this.commands() != null) {
            this.commands().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("clientData", this.clientData(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("taskType", this.taskType == null ? null : this.taskType.toString());
        jsonWriter.writeJsonField("input", (JsonSerializable)this.input);
        return jsonWriter.writeEndObject();
    }

    public static InstallOciDriverTaskProperties fromJson(JsonReader jsonReader) throws IOException {
        return (InstallOciDriverTaskProperties)jsonReader.readObject(reader -> {
            InstallOciDriverTaskProperties deserializedInstallOciDriverTaskProperties = new InstallOciDriverTaskProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errors".equals(fieldName)) {
                    List errors = reader.readArray(reader1 -> ManagementError.fromJson((JsonReader)reader1));
                    deserializedInstallOciDriverTaskProperties.withErrors(errors);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedInstallOciDriverTaskProperties.withState(TaskState.fromString(reader.getString()));
                    continue;
                }
                if ("commands".equals(fieldName)) {
                    List commands = reader.readArray(reader1 -> CommandPropertiesInner.fromJson(reader1));
                    deserializedInstallOciDriverTaskProperties.withCommands(commands);
                    continue;
                }
                if ("clientData".equals(fieldName)) {
                    Map clientData = reader.readMap(reader1 -> reader1.getString());
                    deserializedInstallOciDriverTaskProperties.withClientData(clientData);
                    continue;
                }
                if ("taskType".equals(fieldName)) {
                    deserializedInstallOciDriverTaskProperties.taskType = TaskType.fromString(reader.getString());
                    continue;
                }
                if ("input".equals(fieldName)) {
                    deserializedInstallOciDriverTaskProperties.input = InstallOciDriverTaskInput.fromJson(reader);
                    continue;
                }
                if ("output".equals(fieldName)) {
                    List output;
                    deserializedInstallOciDriverTaskProperties.output = output = reader.readArray(reader1 -> InstallOciDriverTaskOutput.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInstallOciDriverTaskProperties;
        });
    }
}

