/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.ReportableException;
import java.io.IOException;
import java.util.List;

public final class GetUserTablesSqlSyncTaskOutput
implements JsonSerializable<GetUserTablesSqlSyncTaskOutput> {
    private String databasesToSourceTables;
    private String databasesToTargetTables;
    private String tableValidationErrors;
    private List<ReportableException> validationErrors;

    public String databasesToSourceTables() {
        return this.databasesToSourceTables;
    }

    public String databasesToTargetTables() {
        return this.databasesToTargetTables;
    }

    public String tableValidationErrors() {
        return this.tableValidationErrors;
    }

    public List<ReportableException> validationErrors() {
        return this.validationErrors;
    }

    public void validate() {
        if (this.validationErrors() != null) {
            this.validationErrors().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static GetUserTablesSqlSyncTaskOutput fromJson(JsonReader jsonReader) throws IOException {
        return (GetUserTablesSqlSyncTaskOutput)jsonReader.readObject(reader -> {
            GetUserTablesSqlSyncTaskOutput deserializedGetUserTablesSqlSyncTaskOutput = new GetUserTablesSqlSyncTaskOutput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("databasesToSourceTables".equals(fieldName)) {
                    deserializedGetUserTablesSqlSyncTaskOutput.databasesToSourceTables = reader.getString();
                    continue;
                }
                if ("databasesToTargetTables".equals(fieldName)) {
                    deserializedGetUserTablesSqlSyncTaskOutput.databasesToTargetTables = reader.getString();
                    continue;
                }
                if ("tableValidationErrors".equals(fieldName)) {
                    deserializedGetUserTablesSqlSyncTaskOutput.tableValidationErrors = reader.getString();
                    continue;
                }
                if ("validationErrors".equals(fieldName)) {
                    List validationErrors;
                    deserializedGetUserTablesSqlSyncTaskOutput.validationErrors = validationErrors = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGetUserTablesSqlSyncTaskOutput;
        });
    }
}

