/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.PostgreSqlConnectionInfo;
import java.io.IOException;
import java.util.List;

public final class GetUserTablesPostgreSqlTaskInput
implements JsonSerializable<GetUserTablesPostgreSqlTaskInput> {
    private PostgreSqlConnectionInfo connectionInfo;
    private List<String> selectedDatabases;
    private static final ClientLogger LOGGER = new ClientLogger(GetUserTablesPostgreSqlTaskInput.class);

    public PostgreSqlConnectionInfo connectionInfo() {
        return this.connectionInfo;
    }

    public GetUserTablesPostgreSqlTaskInput withConnectionInfo(PostgreSqlConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        return this;
    }

    public List<String> selectedDatabases() {
        return this.selectedDatabases;
    }

    public GetUserTablesPostgreSqlTaskInput withSelectedDatabases(List<String> selectedDatabases) {
        this.selectedDatabases = selectedDatabases;
        return this;
    }

    public void validate() {
        if (this.connectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property connectionInfo in model GetUserTablesPostgreSqlTaskInput"));
        }
        this.connectionInfo().validate();
        if (this.selectedDatabases() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property selectedDatabases in model GetUserTablesPostgreSqlTaskInput"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("connectionInfo", (JsonSerializable)this.connectionInfo);
        jsonWriter.writeArrayField("selectedDatabases", this.selectedDatabases, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static GetUserTablesPostgreSqlTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (GetUserTablesPostgreSqlTaskInput)jsonReader.readObject(reader -> {
            GetUserTablesPostgreSqlTaskInput deserializedGetUserTablesPostgreSqlTaskInput = new GetUserTablesPostgreSqlTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionInfo".equals(fieldName)) {
                    deserializedGetUserTablesPostgreSqlTaskInput.connectionInfo = PostgreSqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("selectedDatabases".equals(fieldName)) {
                    List selectedDatabases;
                    deserializedGetUserTablesPostgreSqlTaskInput.selectedDatabases = selectedDatabases = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGetUserTablesPostgreSqlTaskInput;
        });
    }
}

