/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.FileShare;
import com.azure.resourcemanager.datamigration.models.SelectedCertificateInput;
import com.azure.resourcemanager.datamigration.models.SqlConnectionInfo;
import java.io.IOException;
import java.util.List;

public final class GetTdeCertificatesSqlTaskInput
implements JsonSerializable<GetTdeCertificatesSqlTaskInput> {
    private SqlConnectionInfo connectionInfo;
    private FileShare backupFileShare;
    private List<SelectedCertificateInput> selectedCertificates;
    private static final ClientLogger LOGGER = new ClientLogger(GetTdeCertificatesSqlTaskInput.class);

    public SqlConnectionInfo connectionInfo() {
        return this.connectionInfo;
    }

    public GetTdeCertificatesSqlTaskInput withConnectionInfo(SqlConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        return this;
    }

    public FileShare backupFileShare() {
        return this.backupFileShare;
    }

    public GetTdeCertificatesSqlTaskInput withBackupFileShare(FileShare backupFileShare) {
        this.backupFileShare = backupFileShare;
        return this;
    }

    public List<SelectedCertificateInput> selectedCertificates() {
        return this.selectedCertificates;
    }

    public GetTdeCertificatesSqlTaskInput withSelectedCertificates(List<SelectedCertificateInput> selectedCertificates) {
        this.selectedCertificates = selectedCertificates;
        return this;
    }

    public void validate() {
        if (this.connectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property connectionInfo in model GetTdeCertificatesSqlTaskInput"));
        }
        this.connectionInfo().validate();
        if (this.backupFileShare() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property backupFileShare in model GetTdeCertificatesSqlTaskInput"));
        }
        this.backupFileShare().validate();
        if (this.selectedCertificates() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property selectedCertificates in model GetTdeCertificatesSqlTaskInput"));
        }
        this.selectedCertificates().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("connectionInfo", (JsonSerializable)this.connectionInfo);
        jsonWriter.writeJsonField("backupFileShare", (JsonSerializable)this.backupFileShare);
        jsonWriter.writeArrayField("selectedCertificates", this.selectedCertificates, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static GetTdeCertificatesSqlTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (GetTdeCertificatesSqlTaskInput)jsonReader.readObject(reader -> {
            GetTdeCertificatesSqlTaskInput deserializedGetTdeCertificatesSqlTaskInput = new GetTdeCertificatesSqlTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionInfo".equals(fieldName)) {
                    deserializedGetTdeCertificatesSqlTaskInput.connectionInfo = SqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("backupFileShare".equals(fieldName)) {
                    deserializedGetTdeCertificatesSqlTaskInput.backupFileShare = FileShare.fromJson(reader);
                    continue;
                }
                if ("selectedCertificates".equals(fieldName)) {
                    List selectedCertificates;
                    deserializedGetTdeCertificatesSqlTaskInput.selectedCertificates = selectedCertificates = reader.readArray(reader1 -> SelectedCertificateInput.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGetTdeCertificatesSqlTaskInput;
        });
    }
}

