/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationBaseProperties;
import com.azure.resourcemanager.datamigration.models.ErrorInfo;
import com.azure.resourcemanager.datamigration.models.MongoConnectionInformation;
import com.azure.resourcemanager.datamigration.models.MongoMigrationCollection;
import com.azure.resourcemanager.datamigration.models.ProvisioningState;
import com.azure.resourcemanager.datamigration.models.ResourceType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class DatabaseMigrationPropertiesCosmosDbMongo
extends DatabaseMigrationBaseProperties {
    private ResourceType kind = ResourceType.MONGO_TO_COSMOS_DB_MONGO;
    private MongoConnectionInformation sourceMongoConnection;
    private MongoConnectionInformation targetMongoConnection;
    private List<MongoMigrationCollection> collectionList;

    @Override
    public ResourceType kind() {
        return this.kind;
    }

    public MongoConnectionInformation sourceMongoConnection() {
        return this.sourceMongoConnection;
    }

    public DatabaseMigrationPropertiesCosmosDbMongo withSourceMongoConnection(MongoConnectionInformation sourceMongoConnection) {
        this.sourceMongoConnection = sourceMongoConnection;
        return this;
    }

    public MongoConnectionInformation targetMongoConnection() {
        return this.targetMongoConnection;
    }

    public DatabaseMigrationPropertiesCosmosDbMongo withTargetMongoConnection(MongoConnectionInformation targetMongoConnection) {
        this.targetMongoConnection = targetMongoConnection;
        return this;
    }

    public List<MongoMigrationCollection> collectionList() {
        return this.collectionList;
    }

    public DatabaseMigrationPropertiesCosmosDbMongo withCollectionList(List<MongoMigrationCollection> collectionList) {
        this.collectionList = collectionList;
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesCosmosDbMongo withScope(String scope) {
        super.withScope(scope);
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesCosmosDbMongo withMigrationService(String migrationService) {
        super.withMigrationService(migrationService);
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesCosmosDbMongo withMigrationOperationId(String migrationOperationId) {
        super.withMigrationOperationId(migrationOperationId);
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesCosmosDbMongo withProvisioningError(String provisioningError) {
        super.withProvisioningError(provisioningError);
        return this;
    }

    @Override
    public void validate() {
        if (this.sourceMongoConnection() != null) {
            this.sourceMongoConnection().validate();
        }
        if (this.targetMongoConnection() != null) {
            this.targetMongoConnection().validate();
        }
        if (this.collectionList() != null) {
            this.collectionList().forEach(e -> e.validate());
        }
        if (this.migrationFailureError() != null) {
            this.migrationFailureError().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scope", this.scope());
        jsonWriter.writeStringField("migrationService", this.migrationService());
        jsonWriter.writeStringField("migrationOperationId", this.migrationOperationId());
        jsonWriter.writeStringField("provisioningError", this.provisioningError());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("sourceMongoConnection", (JsonSerializable)this.sourceMongoConnection);
        jsonWriter.writeJsonField("targetMongoConnection", (JsonSerializable)this.targetMongoConnection);
        jsonWriter.writeArrayField("collectionList", this.collectionList, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DatabaseMigrationPropertiesCosmosDbMongo fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseMigrationPropertiesCosmosDbMongo)jsonReader.readObject(reader -> {
            DatabaseMigrationPropertiesCosmosDbMongo deserializedDatabaseMigrationPropertiesCosmosDbMongo = new DatabaseMigrationPropertiesCosmosDbMongo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scope".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesCosmosDbMongo.withScope(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesCosmosDbMongo.withProvisioningState(ProvisioningState.fromString(reader.getString()));
                    continue;
                }
                if ("migrationStatus".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesCosmosDbMongo.withMigrationStatus(reader.getString());
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesCosmosDbMongo.withStartedOn((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesCosmosDbMongo.withEndedOn((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("migrationService".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesCosmosDbMongo.withMigrationService(reader.getString());
                    continue;
                }
                if ("migrationOperationId".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesCosmosDbMongo.withMigrationOperationId(reader.getString());
                    continue;
                }
                if ("migrationFailureError".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesCosmosDbMongo.withMigrationFailureError(ErrorInfo.fromJson(reader));
                    continue;
                }
                if ("provisioningError".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesCosmosDbMongo.withProvisioningError(reader.getString());
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesCosmosDbMongo.kind = ResourceType.fromString(reader.getString());
                    continue;
                }
                if ("sourceMongoConnection".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesCosmosDbMongo.sourceMongoConnection = MongoConnectionInformation.fromJson(reader);
                    continue;
                }
                if ("targetMongoConnection".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesCosmosDbMongo.targetMongoConnection = MongoConnectionInformation.fromJson(reader);
                    continue;
                }
                if ("collectionList".equals(fieldName)) {
                    List collectionList;
                    deserializedDatabaseMigrationPropertiesCosmosDbMongo.collectionList = collectionList = reader.readArray(reader1 -> MongoMigrationCollection.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseMigrationPropertiesCosmosDbMongo;
        });
    }
}

