/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MigrationState;
import java.io.IOException;
import java.time.OffsetDateTime;

public class DataItemMigrationSummaryResult
implements JsonSerializable<DataItemMigrationSummaryResult> {
    private String name;
    private OffsetDateTime startedOn;
    private OffsetDateTime endedOn;
    private MigrationState state;
    private String statusMessage;
    private Long itemsCount;
    private Long itemsCompletedCount;
    private String errorPrefix;
    private String resultPrefix;

    public String name() {
        return this.name;
    }

    DataItemMigrationSummaryResult withName(String name) {
        this.name = name;
        return this;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    DataItemMigrationSummaryResult withStartedOn(OffsetDateTime startedOn) {
        this.startedOn = startedOn;
        return this;
    }

    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    DataItemMigrationSummaryResult withEndedOn(OffsetDateTime endedOn) {
        this.endedOn = endedOn;
        return this;
    }

    public MigrationState state() {
        return this.state;
    }

    DataItemMigrationSummaryResult withState(MigrationState state) {
        this.state = state;
        return this;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    DataItemMigrationSummaryResult withStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        return this;
    }

    public Long itemsCount() {
        return this.itemsCount;
    }

    DataItemMigrationSummaryResult withItemsCount(Long itemsCount) {
        this.itemsCount = itemsCount;
        return this;
    }

    public Long itemsCompletedCount() {
        return this.itemsCompletedCount;
    }

    DataItemMigrationSummaryResult withItemsCompletedCount(Long itemsCompletedCount) {
        this.itemsCompletedCount = itemsCompletedCount;
        return this;
    }

    public String errorPrefix() {
        return this.errorPrefix;
    }

    DataItemMigrationSummaryResult withErrorPrefix(String errorPrefix) {
        this.errorPrefix = errorPrefix;
        return this;
    }

    public String resultPrefix() {
        return this.resultPrefix;
    }

    DataItemMigrationSummaryResult withResultPrefix(String resultPrefix) {
        this.resultPrefix = resultPrefix;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static DataItemMigrationSummaryResult fromJson(JsonReader jsonReader) throws IOException {
        return (DataItemMigrationSummaryResult)jsonReader.readObject(reader -> {
            DataItemMigrationSummaryResult deserializedDataItemMigrationSummaryResult = new DataItemMigrationSummaryResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDataItemMigrationSummaryResult.name = reader.getString();
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedDataItemMigrationSummaryResult.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedDataItemMigrationSummaryResult.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedDataItemMigrationSummaryResult.state = MigrationState.fromString(reader.getString());
                    continue;
                }
                if ("statusMessage".equals(fieldName)) {
                    deserializedDataItemMigrationSummaryResult.statusMessage = reader.getString();
                    continue;
                }
                if ("itemsCount".equals(fieldName)) {
                    deserializedDataItemMigrationSummaryResult.itemsCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("itemsCompletedCount".equals(fieldName)) {
                    deserializedDataItemMigrationSummaryResult.itemsCompletedCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("errorPrefix".equals(fieldName)) {
                    deserializedDataItemMigrationSummaryResult.errorPrefix = reader.getString();
                    continue;
                }
                if ("resultPrefix".equals(fieldName)) {
                    deserializedDataItemMigrationSummaryResult.resultPrefix = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataItemMigrationSummaryResult;
        });
    }
}

