/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MiSqlConnectionInfo;
import com.azure.resourcemanager.datamigration.models.MongoDbConnectionInfo;
import com.azure.resourcemanager.datamigration.models.MySqlConnectionInfo;
import com.azure.resourcemanager.datamigration.models.OracleConnectionInfo;
import com.azure.resourcemanager.datamigration.models.PostgreSqlConnectionInfo;
import com.azure.resourcemanager.datamigration.models.SqlConnectionInfo;
import java.io.IOException;

public class ConnectionInfo
implements JsonSerializable<ConnectionInfo> {
    private String type = "ConnectionInfo";
    private String username;
    private String password;

    public String type() {
        return this.type;
    }

    public String username() {
        return this.username;
    }

    public ConnectionInfo withUsername(String username) {
        this.username = username;
        return this;
    }

    public String password() {
        return this.password;
    }

    public ConnectionInfo withPassword(String password) {
        this.password = password;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("userName", this.username);
        jsonWriter.writeStringField("password", this.password);
        return jsonWriter.writeEndObject();
    }

    public static ConnectionInfo fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionInfo)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ConnectionInfo connectionInfo;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("MongoDbConnectionInfo".equals(discriminatorValue)) {
                    connectionInfo = MongoDbConnectionInfo.fromJson(readerToUse.reset());
                    return connectionInfo;
                }
                if ("SqlConnectionInfo".equals(discriminatorValue)) {
                    connectionInfo = SqlConnectionInfo.fromJson(readerToUse.reset());
                    return connectionInfo;
                }
                if ("MySqlConnectionInfo".equals(discriminatorValue)) {
                    connectionInfo = MySqlConnectionInfo.fromJson(readerToUse.reset());
                    return connectionInfo;
                }
                if ("OracleConnectionInfo".equals(discriminatorValue)) {
                    connectionInfo = OracleConnectionInfo.fromJson(readerToUse.reset());
                    return connectionInfo;
                }
                if ("PostgreSqlConnectionInfo".equals(discriminatorValue)) {
                    connectionInfo = PostgreSqlConnectionInfo.fromJson(readerToUse.reset());
                    return connectionInfo;
                }
                if ("MiSqlConnectionInfo".equals(discriminatorValue)) {
                    connectionInfo = MiSqlConnectionInfo.fromJson(readerToUse.reset());
                    return connectionInfo;
                }
                connectionInfo = ConnectionInfo.fromJsonKnownDiscriminator(readerToUse.reset());
                return connectionInfo;
            }
        });
    }

    static ConnectionInfo fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ConnectionInfo)jsonReader.readObject(reader -> {
            ConnectionInfo deserializedConnectionInfo = new ConnectionInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedConnectionInfo.type = reader.getString();
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedConnectionInfo.username = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedConnectionInfo.password = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionInfo;
        });
    }
}

