/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.ReportableException;
import java.io.IOException;
import java.util.List;

public final class ConnectToTargetSqlMISyncTaskOutput
implements JsonSerializable<ConnectToTargetSqlMISyncTaskOutput> {
    private String targetServerVersion;
    private String targetServerBrandVersion;
    private List<ReportableException> validationErrors;

    public String targetServerVersion() {
        return this.targetServerVersion;
    }

    public String targetServerBrandVersion() {
        return this.targetServerBrandVersion;
    }

    public List<ReportableException> validationErrors() {
        return this.validationErrors;
    }

    public void validate() {
        if (this.validationErrors() != null) {
            this.validationErrors().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ConnectToTargetSqlMISyncTaskOutput fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectToTargetSqlMISyncTaskOutput)jsonReader.readObject(reader -> {
            ConnectToTargetSqlMISyncTaskOutput deserializedConnectToTargetSqlMISyncTaskOutput = new ConnectToTargetSqlMISyncTaskOutput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetServerVersion".equals(fieldName)) {
                    deserializedConnectToTargetSqlMISyncTaskOutput.targetServerVersion = reader.getString();
                    continue;
                }
                if ("targetServerBrandVersion".equals(fieldName)) {
                    deserializedConnectToTargetSqlMISyncTaskOutput.targetServerBrandVersion = reader.getString();
                    continue;
                }
                if ("validationErrors".equals(fieldName)) {
                    List validationErrors;
                    deserializedConnectToTargetSqlMISyncTaskOutput.validationErrors = validationErrors = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectToTargetSqlMISyncTaskOutput;
        });
    }
}

