/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.ConnectToSourceSqlServerTaskOutput;
import com.azure.resourcemanager.datamigration.models.LoginType;
import com.azure.resourcemanager.datamigration.models.MigrationEligibilityInfo;
import java.io.IOException;

public final class ConnectToSourceSqlServerTaskOutputLoginLevel
extends ConnectToSourceSqlServerTaskOutput {
    private String resultType = "LoginLevelOutput";
    private String name;
    private LoginType loginType;
    private String defaultDatabase;
    private Boolean isEnabled;
    private MigrationEligibilityInfo migrationEligibility;

    @Override
    public String resultType() {
        return this.resultType;
    }

    public String name() {
        return this.name;
    }

    public LoginType loginType() {
        return this.loginType;
    }

    public String defaultDatabase() {
        return this.defaultDatabase;
    }

    public Boolean isEnabled() {
        return this.isEnabled;
    }

    public MigrationEligibilityInfo migrationEligibility() {
        return this.migrationEligibility;
    }

    @Override
    public void validate() {
        if (this.migrationEligibility() != null) {
            this.migrationEligibility().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultType", this.resultType);
        return jsonWriter.writeEndObject();
    }

    public static ConnectToSourceSqlServerTaskOutputLoginLevel fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectToSourceSqlServerTaskOutputLoginLevel)jsonReader.readObject(reader -> {
            ConnectToSourceSqlServerTaskOutputLoginLevel deserializedConnectToSourceSqlServerTaskOutputLoginLevel = new ConnectToSourceSqlServerTaskOutputLoginLevel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputLoginLevel.withId(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputLoginLevel.resultType = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputLoginLevel.name = reader.getString();
                    continue;
                }
                if ("loginType".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputLoginLevel.loginType = LoginType.fromString(reader.getString());
                    continue;
                }
                if ("defaultDatabase".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputLoginLevel.defaultDatabase = reader.getString();
                    continue;
                }
                if ("isEnabled".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputLoginLevel.isEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("migrationEligibility".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputLoginLevel.migrationEligibility = MigrationEligibilityInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectToSourceSqlServerTaskOutputLoginLevel;
        });
    }
}

