/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.ConnectToSourceSqlServerTaskOutput;
import com.azure.resourcemanager.datamigration.models.DatabaseCompatLevel;
import com.azure.resourcemanager.datamigration.models.DatabaseFileInfo;
import com.azure.resourcemanager.datamigration.models.DatabaseState;
import java.io.IOException;
import java.util.List;

public final class ConnectToSourceSqlServerTaskOutputDatabaseLevel
extends ConnectToSourceSqlServerTaskOutput {
    private String resultType = "DatabaseLevelOutput";
    private String name;
    private Double sizeMB;
    private List<DatabaseFileInfo> databaseFiles;
    private DatabaseCompatLevel compatibilityLevel;
    private DatabaseState databaseState;

    @Override
    public String resultType() {
        return this.resultType;
    }

    public String name() {
        return this.name;
    }

    public Double sizeMB() {
        return this.sizeMB;
    }

    public List<DatabaseFileInfo> databaseFiles() {
        return this.databaseFiles;
    }

    public DatabaseCompatLevel compatibilityLevel() {
        return this.compatibilityLevel;
    }

    public DatabaseState databaseState() {
        return this.databaseState;
    }

    @Override
    public void validate() {
        if (this.databaseFiles() != null) {
            this.databaseFiles().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultType", this.resultType);
        return jsonWriter.writeEndObject();
    }

    public static ConnectToSourceSqlServerTaskOutputDatabaseLevel fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectToSourceSqlServerTaskOutputDatabaseLevel)jsonReader.readObject(reader -> {
            ConnectToSourceSqlServerTaskOutputDatabaseLevel deserializedConnectToSourceSqlServerTaskOutputDatabaseLevel = new ConnectToSourceSqlServerTaskOutputDatabaseLevel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputDatabaseLevel.withId(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputDatabaseLevel.resultType = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputDatabaseLevel.name = reader.getString();
                    continue;
                }
                if ("sizeMB".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputDatabaseLevel.sizeMB = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("databaseFiles".equals(fieldName)) {
                    List databaseFiles;
                    deserializedConnectToSourceSqlServerTaskOutputDatabaseLevel.databaseFiles = databaseFiles = reader.readArray(reader1 -> DatabaseFileInfo.fromJson(reader1));
                    continue;
                }
                if ("compatibilityLevel".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputDatabaseLevel.compatibilityLevel = DatabaseCompatLevel.fromString(reader.getString());
                    continue;
                }
                if ("databaseState".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputDatabaseLevel.databaseState = DatabaseState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectToSourceSqlServerTaskOutputDatabaseLevel;
        });
    }
}

