/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.BackupFileStatus;
import java.io.IOException;

public final class BackupFileInfo
implements JsonSerializable<BackupFileInfo> {
    private String fileLocation;
    private Integer familySequenceNumber;
    private BackupFileStatus status;

    public String fileLocation() {
        return this.fileLocation;
    }

    public BackupFileInfo withFileLocation(String fileLocation) {
        this.fileLocation = fileLocation;
        return this;
    }

    public Integer familySequenceNumber() {
        return this.familySequenceNumber;
    }

    public BackupFileInfo withFamilySequenceNumber(Integer familySequenceNumber) {
        this.familySequenceNumber = familySequenceNumber;
        return this;
    }

    public BackupFileStatus status() {
        return this.status;
    }

    public BackupFileInfo withStatus(BackupFileStatus status) {
        this.status = status;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("fileLocation", this.fileLocation);
        jsonWriter.writeNumberField("familySequenceNumber", (Number)this.familySequenceNumber);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    public static BackupFileInfo fromJson(JsonReader jsonReader) throws IOException {
        return (BackupFileInfo)jsonReader.readObject(reader -> {
            BackupFileInfo deserializedBackupFileInfo = new BackupFileInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fileLocation".equals(fieldName)) {
                    deserializedBackupFileInfo.fileLocation = reader.getString();
                    continue;
                }
                if ("familySequenceNumber".equals(fieldName)) {
                    deserializedBackupFileInfo.familySequenceNumber = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedBackupFileInfo.status = BackupFileStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupFileInfo;
        });
    }
}

