/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datamigration.DataMigrationManager;
import com.azure.resourcemanager.datamigration.fluent.UsagesClient;
import com.azure.resourcemanager.datamigration.fluent.models.QuotaInner;
import com.azure.resourcemanager.datamigration.implementation.QuotaImpl;
import com.azure.resourcemanager.datamigration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datamigration.models.Quota;
import com.azure.resourcemanager.datamigration.models.Usages;

public final class UsagesImpl
implements Usages {
    private static final ClientLogger LOGGER = new ClientLogger(UsagesImpl.class);
    private final UsagesClient innerClient;
    private final DataMigrationManager serviceManager;

    public UsagesImpl(UsagesClient innerClient, DataMigrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Quota> list(String location) {
        PagedIterable<QuotaInner> inner = this.serviceClient().list(location);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new QuotaImpl((QuotaInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<Quota> list(String location, Context context) {
        PagedIterable<QuotaInner> inner = this.serviceClient().list(location, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new QuotaImpl((QuotaInner)inner1, this.manager()));
    }

    private UsagesClient serviceClient() {
        return this.innerClient;
    }

    private DataMigrationManager manager() {
        return this.serviceManager;
    }
}

