/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datamigration.DataMigrationManager;
import com.azure.resourcemanager.datamigration.fluent.TasksClient;
import com.azure.resourcemanager.datamigration.fluent.models.CommandPropertiesInner;
import com.azure.resourcemanager.datamigration.fluent.models.ProjectTaskInner;
import com.azure.resourcemanager.datamigration.implementation.CommandPropertiesImpl;
import com.azure.resourcemanager.datamigration.implementation.ProjectTaskImpl;
import com.azure.resourcemanager.datamigration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datamigration.models.CommandProperties;
import com.azure.resourcemanager.datamigration.models.ProjectTask;
import com.azure.resourcemanager.datamigration.models.Tasks;

public final class TasksImpl
implements Tasks {
    private static final ClientLogger LOGGER = new ClientLogger(TasksImpl.class);
    private final TasksClient innerClient;
    private final DataMigrationManager serviceManager;

    public TasksImpl(TasksClient innerClient, DataMigrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ProjectTask> list(String groupName, String serviceName, String projectName) {
        PagedIterable<ProjectTaskInner> inner = this.serviceClient().list(groupName, serviceName, projectName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProjectTaskImpl((ProjectTaskInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ProjectTask> list(String groupName, String serviceName, String projectName, String taskType, Context context) {
        PagedIterable<ProjectTaskInner> inner = this.serviceClient().list(groupName, serviceName, projectName, taskType, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProjectTaskImpl((ProjectTaskInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ProjectTask> getWithResponse(String groupName, String serviceName, String projectName, String taskName, String expand, Context context) {
        Response<ProjectTaskInner> inner = this.serviceClient().getWithResponse(groupName, serviceName, projectName, taskName, expand, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ProjectTaskImpl((ProjectTaskInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ProjectTask get(String groupName, String serviceName, String projectName, String taskName) {
        ProjectTaskInner inner = this.serviceClient().get(groupName, serviceName, projectName, taskName);
        if (inner != null) {
            return new ProjectTaskImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String groupName, String serviceName, String projectName, String taskName, Boolean deleteRunningTasks, Context context) {
        return this.serviceClient().deleteWithResponse(groupName, serviceName, projectName, taskName, deleteRunningTasks, context);
    }

    @Override
    public void delete(String groupName, String serviceName, String projectName, String taskName) {
        this.serviceClient().delete(groupName, serviceName, projectName, taskName);
    }

    @Override
    public Response<ProjectTask> cancelWithResponse(String groupName, String serviceName, String projectName, String taskName, Context context) {
        Response<ProjectTaskInner> inner = this.serviceClient().cancelWithResponse(groupName, serviceName, projectName, taskName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ProjectTaskImpl((ProjectTaskInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ProjectTask cancel(String groupName, String serviceName, String projectName, String taskName) {
        ProjectTaskInner inner = this.serviceClient().cancel(groupName, serviceName, projectName, taskName);
        if (inner != null) {
            return new ProjectTaskImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<CommandProperties> commandWithResponse(String groupName, String serviceName, String projectName, String taskName, CommandPropertiesInner parameters, Context context) {
        Response<CommandPropertiesInner> inner = this.serviceClient().commandWithResponse(groupName, serviceName, projectName, taskName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CommandPropertiesImpl((CommandPropertiesInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CommandProperties command(String groupName, String serviceName, String projectName, String taskName, CommandPropertiesInner parameters) {
        CommandPropertiesInner inner = this.serviceClient().command(groupName, serviceName, projectName, taskName, parameters);
        if (inner != null) {
            return new CommandPropertiesImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ProjectTask getById(String id) {
        String groupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (groupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String taskName = ResourceManagerUtils.getValueFromIdByName(id, "tasks");
        if (taskName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tasks'.", id)));
        }
        String localExpand = null;
        return (ProjectTask)this.getWithResponse(groupName, serviceName, projectName, taskName, localExpand, Context.NONE).getValue();
    }

    @Override
    public Response<ProjectTask> getByIdWithResponse(String id, String expand, Context context) {
        String groupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (groupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String taskName = ResourceManagerUtils.getValueFromIdByName(id, "tasks");
        if (taskName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tasks'.", id)));
        }
        return this.getWithResponse(groupName, serviceName, projectName, taskName, expand, context);
    }

    @Override
    public void deleteById(String id) {
        String groupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (groupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String taskName = ResourceManagerUtils.getValueFromIdByName(id, "tasks");
        if (taskName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tasks'.", id)));
        }
        Boolean localDeleteRunningTasks = null;
        this.deleteWithResponse(groupName, serviceName, projectName, taskName, localDeleteRunningTasks, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Boolean deleteRunningTasks, Context context) {
        String groupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (groupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String taskName = ResourceManagerUtils.getValueFromIdByName(id, "tasks");
        if (taskName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tasks'.", id)));
        }
        return this.deleteWithResponse(groupName, serviceName, projectName, taskName, deleteRunningTasks, context);
    }

    private TasksClient serviceClient() {
        return this.innerClient;
    }

    private DataMigrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public ProjectTaskImpl define(String name) {
        return new ProjectTaskImpl(name, this.manager());
    }
}

