/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datamigration.DataMigrationManager;
import com.azure.resourcemanager.datamigration.fluent.ResourceSkusClient;
import com.azure.resourcemanager.datamigration.fluent.models.ResourceSkuInner;
import com.azure.resourcemanager.datamigration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datamigration.implementation.ResourceSkuImpl;
import com.azure.resourcemanager.datamigration.models.ResourceSku;
import com.azure.resourcemanager.datamigration.models.ResourceSkus;

public final class ResourceSkusImpl
implements ResourceSkus {
    private static final ClientLogger LOGGER = new ClientLogger(ResourceSkusImpl.class);
    private final ResourceSkusClient innerClient;
    private final DataMigrationManager serviceManager;

    public ResourceSkusImpl(ResourceSkusClient innerClient, DataMigrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ResourceSku> list() {
        PagedIterable<ResourceSkuInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ResourceSkuImpl((ResourceSkuInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ResourceSku> list(Context context) {
        PagedIterable<ResourceSkuInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ResourceSkuImpl((ResourceSkuInner)inner1, this.manager()));
    }

    private ResourceSkusClient serviceClient() {
        return this.innerClient;
    }

    private DataMigrationManager manager() {
        return this.serviceManager;
    }
}

