/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datamigration.DataMigrationManager;
import com.azure.resourcemanager.datamigration.fluent.models.CommandPropertiesInner;
import com.azure.resourcemanager.datamigration.fluent.models.ProjectTaskInner;
import com.azure.resourcemanager.datamigration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datamigration.models.CommandProperties;
import com.azure.resourcemanager.datamigration.models.ProjectTask;
import com.azure.resourcemanager.datamigration.models.ProjectTaskProperties;
import com.azure.resourcemanager.datamigration.models.SystemDataAutoGenerated;

public final class ProjectTaskImpl
implements ProjectTask,
ProjectTask.Definition,
ProjectTask.Update {
    private ProjectTaskInner innerObject;
    private final DataMigrationManager serviceManager;
    private String groupName;
    private String serviceName;
    private String projectName;
    private String taskName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public ProjectTaskProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemDataAutoGenerated systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.groupName;
    }

    @Override
    public ProjectTaskInner innerModel() {
        return this.innerObject;
    }

    private DataMigrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public ProjectTaskImpl withExistingProject(String groupName, String serviceName, String projectName) {
        this.groupName = groupName;
        this.serviceName = serviceName;
        this.projectName = projectName;
        return this;
    }

    @Override
    public ProjectTask create() {
        this.innerObject = (ProjectTaskInner)((Object)this.serviceManager.serviceClient().getTasks().createOrUpdateWithResponse(this.groupName, this.serviceName, this.projectName, this.taskName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ProjectTask create(Context context) {
        this.innerObject = (ProjectTaskInner)((Object)this.serviceManager.serviceClient().getTasks().createOrUpdateWithResponse(this.groupName, this.serviceName, this.projectName, this.taskName, this.innerModel(), context).getValue());
        return this;
    }

    ProjectTaskImpl(String name, DataMigrationManager serviceManager) {
        this.innerObject = new ProjectTaskInner();
        this.serviceManager = serviceManager;
        this.taskName = name;
    }

    @Override
    public ProjectTaskImpl update() {
        return this;
    }

    @Override
    public ProjectTask apply() {
        this.innerObject = (ProjectTaskInner)((Object)this.serviceManager.serviceClient().getTasks().updateWithResponse(this.groupName, this.serviceName, this.projectName, this.taskName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ProjectTask apply(Context context) {
        this.innerObject = (ProjectTaskInner)((Object)this.serviceManager.serviceClient().getTasks().updateWithResponse(this.groupName, this.serviceName, this.projectName, this.taskName, this.innerModel(), context).getValue());
        return this;
    }

    ProjectTaskImpl(ProjectTaskInner innerObject, DataMigrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.groupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "services");
        this.projectName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "projects");
        this.taskName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "tasks");
    }

    @Override
    public ProjectTask refresh() {
        String localExpand = null;
        this.innerObject = (ProjectTaskInner)((Object)this.serviceManager.serviceClient().getTasks().getWithResponse(this.groupName, this.serviceName, this.projectName, this.taskName, localExpand, Context.NONE).getValue());
        return this;
    }

    @Override
    public ProjectTask refresh(Context context) {
        String localExpand = null;
        this.innerObject = (ProjectTaskInner)((Object)this.serviceManager.serviceClient().getTasks().getWithResponse(this.groupName, this.serviceName, this.projectName, this.taskName, localExpand, context).getValue());
        return this;
    }

    @Override
    public Response<ProjectTask> cancelWithResponse(Context context) {
        return this.serviceManager.tasks().cancelWithResponse(this.groupName, this.serviceName, this.projectName, this.taskName, context);
    }

    @Override
    public ProjectTask cancel() {
        return this.serviceManager.tasks().cancel(this.groupName, this.serviceName, this.projectName, this.taskName);
    }

    @Override
    public Response<CommandProperties> commandWithResponse(CommandPropertiesInner parameters, Context context) {
        return this.serviceManager.tasks().commandWithResponse(this.groupName, this.serviceName, this.projectName, this.taskName, parameters, context);
    }

    @Override
    public CommandProperties command(CommandPropertiesInner parameters) {
        return this.serviceManager.tasks().command(this.groupName, this.serviceName, this.projectName, this.taskName, parameters);
    }

    @Override
    public ProjectTaskImpl withEtag(String etag) {
        this.innerModel().withEtag(etag);
        return this;
    }

    @Override
    public ProjectTaskImpl withProperties(ProjectTaskProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

