/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datamigration.DataMigrationManager;
import com.azure.resourcemanager.datamigration.fluent.models.MigrationServiceInner;
import com.azure.resourcemanager.datamigration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datamigration.models.MigrationService;
import com.azure.resourcemanager.datamigration.models.MigrationServiceUpdate;
import com.azure.resourcemanager.datamigration.models.ProvisioningState;
import java.util.Collections;
import java.util.Map;

public final class MigrationServiceImpl
implements MigrationService,
MigrationService.Definition,
MigrationService.Update {
    private MigrationServiceInner innerObject;
    private final DataMigrationManager serviceManager;
    private String resourceGroupName;
    private String migrationServiceName;
    private MigrationServiceUpdate updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String integrationRuntimeState() {
        return this.innerModel().integrationRuntimeState();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public MigrationServiceInner innerModel() {
        return this.innerObject;
    }

    private DataMigrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public MigrationServiceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public MigrationService create() {
        this.innerObject = this.serviceManager.serviceClient().getMigrationServices().createOrUpdate(this.resourceGroupName, this.migrationServiceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public MigrationService create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getMigrationServices().createOrUpdate(this.resourceGroupName, this.migrationServiceName, this.innerModel(), context);
        return this;
    }

    MigrationServiceImpl(String name, DataMigrationManager serviceManager) {
        this.innerObject = new MigrationServiceInner();
        this.serviceManager = serviceManager;
        this.migrationServiceName = name;
    }

    @Override
    public MigrationServiceImpl update() {
        this.updateParameters = new MigrationServiceUpdate();
        return this;
    }

    @Override
    public MigrationService apply() {
        this.innerObject = this.serviceManager.serviceClient().getMigrationServices().update(this.resourceGroupName, this.migrationServiceName, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public MigrationService apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getMigrationServices().update(this.resourceGroupName, this.migrationServiceName, this.updateParameters, context);
        return this;
    }

    MigrationServiceImpl(MigrationServiceInner innerObject, DataMigrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.migrationServiceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "migrationServices");
    }

    @Override
    public MigrationService refresh() {
        this.innerObject = (MigrationServiceInner)((Object)this.serviceManager.serviceClient().getMigrationServices().getByResourceGroupWithResponse(this.resourceGroupName, this.migrationServiceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public MigrationService refresh(Context context) {
        this.innerObject = (MigrationServiceInner)((Object)this.serviceManager.serviceClient().getMigrationServices().getByResourceGroupWithResponse(this.resourceGroupName, this.migrationServiceName, context).getValue());
        return this;
    }

    @Override
    public MigrationServiceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public MigrationServiceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public MigrationServiceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

