/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datamigration.DataMigrationManager;
import com.azure.resourcemanager.datamigration.fluent.DatabaseMigrationsSqlDbsClient;
import com.azure.resourcemanager.datamigration.fluent.models.DatabaseMigrationSqlDbInner;
import com.azure.resourcemanager.datamigration.implementation.DatabaseMigrationSqlDbImpl;
import com.azure.resourcemanager.datamigration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationSqlDb;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationsSqlDbs;
import com.azure.resourcemanager.datamigration.models.MigrationOperationInput;
import java.util.UUID;

public final class DatabaseMigrationsSqlDbsImpl
implements DatabaseMigrationsSqlDbs {
    private static final ClientLogger LOGGER = new ClientLogger(DatabaseMigrationsSqlDbsImpl.class);
    private final DatabaseMigrationsSqlDbsClient innerClient;
    private final DataMigrationManager serviceManager;

    public DatabaseMigrationsSqlDbsImpl(DatabaseMigrationsSqlDbsClient innerClient, DataMigrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DatabaseMigrationSqlDb> getWithResponse(String resourceGroupName, String sqlDbInstanceName, String targetDbName, UUID migrationOperationId, String expand, Context context) {
        Response<DatabaseMigrationSqlDbInner> inner = this.serviceClient().getWithResponse(resourceGroupName, sqlDbInstanceName, targetDbName, migrationOperationId, expand, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DatabaseMigrationSqlDbImpl((DatabaseMigrationSqlDbInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DatabaseMigrationSqlDb get(String resourceGroupName, String sqlDbInstanceName, String targetDbName) {
        DatabaseMigrationSqlDbInner inner = this.serviceClient().get(resourceGroupName, sqlDbInstanceName, targetDbName);
        if (inner != null) {
            return new DatabaseMigrationSqlDbImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String sqlDbInstanceName, String targetDbName) {
        this.serviceClient().delete(resourceGroupName, sqlDbInstanceName, targetDbName);
    }

    @Override
    public void delete(String resourceGroupName, String sqlDbInstanceName, String targetDbName, Boolean force, Context context) {
        this.serviceClient().delete(resourceGroupName, sqlDbInstanceName, targetDbName, force, context);
    }

    @Override
    public void cancel(String resourceGroupName, String sqlDbInstanceName, String targetDbName, MigrationOperationInput parameters) {
        this.serviceClient().cancel(resourceGroupName, sqlDbInstanceName, targetDbName, parameters);
    }

    @Override
    public void cancel(String resourceGroupName, String sqlDbInstanceName, String targetDbName, MigrationOperationInput parameters, Context context) {
        this.serviceClient().cancel(resourceGroupName, sqlDbInstanceName, targetDbName, parameters, context);
    }

    @Override
    public DatabaseMigrationSqlDb getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sqlDbInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "servers");
        if (sqlDbInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String targetDbName = ResourceManagerUtils.getValueFromIdByName(id, "databaseMigrations");
        if (targetDbName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseMigrations'.", id)));
        }
        UUID localMigrationOperationId = null;
        String localExpand = null;
        return (DatabaseMigrationSqlDb)this.getWithResponse(resourceGroupName, sqlDbInstanceName, targetDbName, localMigrationOperationId, localExpand, Context.NONE).getValue();
    }

    @Override
    public Response<DatabaseMigrationSqlDb> getByIdWithResponse(String id, UUID migrationOperationId, String expand, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sqlDbInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "servers");
        if (sqlDbInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String targetDbName = ResourceManagerUtils.getValueFromIdByName(id, "databaseMigrations");
        if (targetDbName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseMigrations'.", id)));
        }
        return this.getWithResponse(resourceGroupName, sqlDbInstanceName, targetDbName, migrationOperationId, expand, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sqlDbInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "servers");
        if (sqlDbInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String targetDbName = ResourceManagerUtils.getValueFromIdByName(id, "databaseMigrations");
        if (targetDbName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseMigrations'.", id)));
        }
        Boolean localForce = null;
        this.delete(resourceGroupName, sqlDbInstanceName, targetDbName, localForce, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Boolean force, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sqlDbInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "servers");
        if (sqlDbInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String targetDbName = ResourceManagerUtils.getValueFromIdByName(id, "databaseMigrations");
        if (targetDbName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseMigrations'.", id)));
        }
        this.delete(resourceGroupName, sqlDbInstanceName, targetDbName, force, context);
    }

    private DatabaseMigrationsSqlDbsClient serviceClient() {
        return this.innerClient;
    }

    private DataMigrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public DatabaseMigrationSqlDbImpl define(String name) {
        return new DatabaseMigrationSqlDbImpl(name, this.manager());
    }
}

