/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datamigration.DataMigrationManager;
import com.azure.resourcemanager.datamigration.fluent.models.DataMigrationServiceInner;
import com.azure.resourcemanager.datamigration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datamigration.models.DataMigrationService;
import com.azure.resourcemanager.datamigration.models.DataMigrationServiceStatusResponse;
import com.azure.resourcemanager.datamigration.models.NameAvailabilityRequest;
import com.azure.resourcemanager.datamigration.models.NameAvailabilityResponse;
import com.azure.resourcemanager.datamigration.models.ServiceProvisioningState;
import com.azure.resourcemanager.datamigration.models.ServiceSku;
import com.azure.resourcemanager.datamigration.models.SystemDataAutoGenerated;
import java.util.Collections;
import java.util.Map;

public final class DataMigrationServiceImpl
implements DataMigrationService,
DataMigrationService.Definition,
DataMigrationService.Update {
    private DataMigrationServiceInner innerObject;
    private final DataMigrationManager serviceManager;
    private String groupName;
    private String serviceName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public String kind() {
        return this.innerModel().kind();
    }

    @Override
    public ServiceSku sku() {
        return this.innerModel().sku();
    }

    @Override
    public SystemDataAutoGenerated systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public ServiceProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String publicKey() {
        return this.innerModel().publicKey();
    }

    @Override
    public String virtualSubnetId() {
        return this.innerModel().virtualSubnetId();
    }

    @Override
    public String virtualNicId() {
        return this.innerModel().virtualNicId();
    }

    @Override
    public String autoStopDelay() {
        return this.innerModel().autoStopDelay();
    }

    @Override
    public Boolean deleteResourcesOnStop() {
        return this.innerModel().deleteResourcesOnStop();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.groupName;
    }

    @Override
    public DataMigrationServiceInner innerModel() {
        return this.innerObject;
    }

    private DataMigrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public DataMigrationServiceImpl withExistingResourceGroup(String groupName) {
        this.groupName = groupName;
        return this;
    }

    @Override
    public DataMigrationService create() {
        this.innerObject = this.serviceManager.serviceClient().getServices().createOrUpdate(this.groupName, this.serviceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public DataMigrationService create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getServices().createOrUpdate(this.groupName, this.serviceName, this.innerModel(), context);
        return this;
    }

    DataMigrationServiceImpl(String name, DataMigrationManager serviceManager) {
        this.innerObject = new DataMigrationServiceInner();
        this.serviceManager = serviceManager;
        this.serviceName = name;
    }

    @Override
    public DataMigrationServiceImpl update() {
        return this;
    }

    @Override
    public DataMigrationService apply() {
        this.innerObject = this.serviceManager.serviceClient().getServices().update(this.groupName, this.serviceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public DataMigrationService apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getServices().update(this.groupName, this.serviceName, this.innerModel(), context);
        return this;
    }

    DataMigrationServiceImpl(DataMigrationServiceInner innerObject, DataMigrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.groupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "services");
    }

    @Override
    public DataMigrationService refresh() {
        this.innerObject = (DataMigrationServiceInner)((Object)this.serviceManager.serviceClient().getServices().getByResourceGroupWithResponse(this.groupName, this.serviceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public DataMigrationService refresh(Context context) {
        this.innerObject = (DataMigrationServiceInner)((Object)this.serviceManager.serviceClient().getServices().getByResourceGroupWithResponse(this.groupName, this.serviceName, context).getValue());
        return this;
    }

    @Override
    public Response<DataMigrationServiceStatusResponse> checkStatusWithResponse(Context context) {
        return this.serviceManager.services().checkStatusWithResponse(this.groupName, this.serviceName, context);
    }

    @Override
    public DataMigrationServiceStatusResponse checkStatus() {
        return this.serviceManager.services().checkStatus(this.groupName, this.serviceName);
    }

    @Override
    public void start() {
        this.serviceManager.services().start(this.groupName, this.serviceName);
    }

    @Override
    public void start(Context context) {
        this.serviceManager.services().start(this.groupName, this.serviceName, context);
    }

    @Override
    public void stop() {
        this.serviceManager.services().stop(this.groupName, this.serviceName);
    }

    @Override
    public void stop(Context context) {
        this.serviceManager.services().stop(this.groupName, this.serviceName, context);
    }

    @Override
    public Response<NameAvailabilityResponse> checkChildrenNameAvailabilityWithResponse(NameAvailabilityRequest parameters, Context context) {
        return this.serviceManager.services().checkChildrenNameAvailabilityWithResponse(this.groupName, this.serviceName, parameters, context);
    }

    @Override
    public NameAvailabilityResponse checkChildrenNameAvailability(NameAvailabilityRequest parameters) {
        return this.serviceManager.services().checkChildrenNameAvailability(this.groupName, this.serviceName, parameters);
    }

    @Override
    public DataMigrationServiceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public DataMigrationServiceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public DataMigrationServiceImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags((Map)tags);
        return this;
    }

    @Override
    public DataMigrationServiceImpl withEtag(String etag) {
        this.innerModel().withEtag(etag);
        return this;
    }

    @Override
    public DataMigrationServiceImpl withKind(String kind) {
        this.innerModel().withKind(kind);
        return this;
    }

    @Override
    public DataMigrationServiceImpl withSku(ServiceSku sku) {
        this.innerModel().withSku(sku);
        return this;
    }

    @Override
    public DataMigrationServiceImpl withPublicKey(String publicKey) {
        this.innerModel().withPublicKey(publicKey);
        return this;
    }

    @Override
    public DataMigrationServiceImpl withVirtualSubnetId(String virtualSubnetId) {
        this.innerModel().withVirtualSubnetId(virtualSubnetId);
        return this;
    }

    @Override
    public DataMigrationServiceImpl withVirtualNicId(String virtualNicId) {
        this.innerModel().withVirtualNicId(virtualNicId);
        return this;
    }

    @Override
    public DataMigrationServiceImpl withAutoStopDelay(String autoStopDelay) {
        this.innerModel().withAutoStopDelay(autoStopDelay);
        return this;
    }

    @Override
    public DataMigrationServiceImpl withDeleteResourcesOnStop(Boolean deleteResourcesOnStop) {
        this.innerModel().withDeleteResourcesOnStop(deleteResourcesOnStop);
        return this;
    }
}

