/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.AzureActiveDirectoryApp;
import com.azure.resourcemanager.datamigration.models.ConnectionInfo;
import com.azure.resourcemanager.datamigration.models.DatabaseInfo;
import com.azure.resourcemanager.datamigration.models.ProjectProvisioningState;
import com.azure.resourcemanager.datamigration.models.ProjectSourcePlatform;
import com.azure.resourcemanager.datamigration.models.ProjectTargetPlatform;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class ProjectProperties
implements JsonSerializable<ProjectProperties> {
    private ProjectSourcePlatform sourcePlatform;
    private AzureActiveDirectoryApp azureAuthenticationInfo;
    private ProjectTargetPlatform targetPlatform;
    private OffsetDateTime creationTime;
    private ConnectionInfo sourceConnectionInfo;
    private ConnectionInfo targetConnectionInfo;
    private List<DatabaseInfo> databasesInfo;
    private ProjectProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(ProjectProperties.class);

    public ProjectSourcePlatform sourcePlatform() {
        return this.sourcePlatform;
    }

    public ProjectProperties withSourcePlatform(ProjectSourcePlatform sourcePlatform) {
        this.sourcePlatform = sourcePlatform;
        return this;
    }

    public AzureActiveDirectoryApp azureAuthenticationInfo() {
        return this.azureAuthenticationInfo;
    }

    public ProjectProperties withAzureAuthenticationInfo(AzureActiveDirectoryApp azureAuthenticationInfo) {
        this.azureAuthenticationInfo = azureAuthenticationInfo;
        return this;
    }

    public ProjectTargetPlatform targetPlatform() {
        return this.targetPlatform;
    }

    public ProjectProperties withTargetPlatform(ProjectTargetPlatform targetPlatform) {
        this.targetPlatform = targetPlatform;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public ConnectionInfo sourceConnectionInfo() {
        return this.sourceConnectionInfo;
    }

    public ProjectProperties withSourceConnectionInfo(ConnectionInfo sourceConnectionInfo) {
        this.sourceConnectionInfo = sourceConnectionInfo;
        return this;
    }

    public ConnectionInfo targetConnectionInfo() {
        return this.targetConnectionInfo;
    }

    public ProjectProperties withTargetConnectionInfo(ConnectionInfo targetConnectionInfo) {
        this.targetConnectionInfo = targetConnectionInfo;
        return this;
    }

    public List<DatabaseInfo> databasesInfo() {
        return this.databasesInfo;
    }

    public ProjectProperties withDatabasesInfo(List<DatabaseInfo> databasesInfo) {
        this.databasesInfo = databasesInfo;
        return this;
    }

    public ProjectProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.sourcePlatform() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourcePlatform in model ProjectProperties"));
        }
        if (this.azureAuthenticationInfo() != null) {
            this.azureAuthenticationInfo().validate();
        }
        if (this.targetPlatform() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetPlatform in model ProjectProperties"));
        }
        if (this.sourceConnectionInfo() != null) {
            this.sourceConnectionInfo().validate();
        }
        if (this.targetConnectionInfo() != null) {
            this.targetConnectionInfo().validate();
        }
        if (this.databasesInfo() != null) {
            this.databasesInfo().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourcePlatform", this.sourcePlatform == null ? null : this.sourcePlatform.toString());
        jsonWriter.writeStringField("targetPlatform", this.targetPlatform == null ? null : this.targetPlatform.toString());
        jsonWriter.writeJsonField("azureAuthenticationInfo", (JsonSerializable)this.azureAuthenticationInfo);
        jsonWriter.writeJsonField("sourceConnectionInfo", (JsonSerializable)this.sourceConnectionInfo);
        jsonWriter.writeJsonField("targetConnectionInfo", (JsonSerializable)this.targetConnectionInfo);
        jsonWriter.writeArrayField("databasesInfo", this.databasesInfo, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ProjectProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ProjectProperties)jsonReader.readObject(reader -> {
            ProjectProperties deserializedProjectProperties = new ProjectProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourcePlatform".equals(fieldName)) {
                    deserializedProjectProperties.sourcePlatform = ProjectSourcePlatform.fromString(reader.getString());
                    continue;
                }
                if ("targetPlatform".equals(fieldName)) {
                    deserializedProjectProperties.targetPlatform = ProjectTargetPlatform.fromString(reader.getString());
                    continue;
                }
                if ("azureAuthenticationInfo".equals(fieldName)) {
                    deserializedProjectProperties.azureAuthenticationInfo = AzureActiveDirectoryApp.fromJson(reader);
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedProjectProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("sourceConnectionInfo".equals(fieldName)) {
                    deserializedProjectProperties.sourceConnectionInfo = ConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("targetConnectionInfo".equals(fieldName)) {
                    deserializedProjectProperties.targetConnectionInfo = ConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("databasesInfo".equals(fieldName)) {
                    List databasesInfo;
                    deserializedProjectProperties.databasesInfo = databasesInfo = reader.readArray(reader1 -> DatabaseInfo.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedProjectProperties.provisioningState = ProjectProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProjectProperties;
        });
    }
}

