/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.NameCheckFailureReason;
import java.io.IOException;

public final class NameAvailabilityResponseInner
implements JsonSerializable<NameAvailabilityResponseInner> {
    private Boolean nameAvailable;
    private NameCheckFailureReason reason;
    private String message;

    public Boolean nameAvailable() {
        return this.nameAvailable;
    }

    public NameAvailabilityResponseInner withNameAvailable(Boolean nameAvailable) {
        this.nameAvailable = nameAvailable;
        return this;
    }

    public NameCheckFailureReason reason() {
        return this.reason;
    }

    public NameAvailabilityResponseInner withReason(NameCheckFailureReason reason) {
        this.reason = reason;
        return this;
    }

    public String message() {
        return this.message;
    }

    public NameAvailabilityResponseInner withMessage(String message) {
        this.message = message;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("nameAvailable", this.nameAvailable);
        jsonWriter.writeStringField("reason", this.reason == null ? null : this.reason.toString());
        jsonWriter.writeStringField("message", this.message);
        return jsonWriter.writeEndObject();
    }

    public static NameAvailabilityResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return (NameAvailabilityResponseInner)jsonReader.readObject(reader -> {
            NameAvailabilityResponseInner deserializedNameAvailabilityResponseInner = new NameAvailabilityResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nameAvailable".equals(fieldName)) {
                    deserializedNameAvailabilityResponseInner.nameAvailable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedNameAvailabilityResponseInner.reason = NameCheckFailureReason.fromString(reader.getString());
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedNameAvailabilityResponseInner.message = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNameAvailabilityResponseInner;
        });
    }
}

