/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.fluent.models.DataMigrationServiceProperties;
import com.azure.resourcemanager.datamigration.models.ServiceProvisioningState;
import com.azure.resourcemanager.datamigration.models.ServiceSku;
import com.azure.resourcemanager.datamigration.models.SystemDataAutoGenerated;
import java.io.IOException;
import java.util.Map;

public final class DataMigrationServiceInner
extends Resource {
    private String etag;
    private String kind;
    private DataMigrationServiceProperties innerProperties;
    private ServiceSku sku;
    private SystemDataAutoGenerated systemData;
    private String type;
    private String name;
    private String id;

    public String etag() {
        return this.etag;
    }

    public DataMigrationServiceInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public String kind() {
        return this.kind;
    }

    public DataMigrationServiceInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    private DataMigrationServiceProperties innerProperties() {
        return this.innerProperties;
    }

    public ServiceSku sku() {
        return this.sku;
    }

    public DataMigrationServiceInner withSku(ServiceSku sku) {
        this.sku = sku;
        return this;
    }

    public SystemDataAutoGenerated systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public DataMigrationServiceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DataMigrationServiceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ServiceProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String publicKey() {
        return this.innerProperties() == null ? null : this.innerProperties().publicKey();
    }

    public DataMigrationServiceInner withPublicKey(String publicKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataMigrationServiceProperties();
        }
        this.innerProperties().withPublicKey(publicKey);
        return this;
    }

    public String virtualSubnetId() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualSubnetId();
    }

    public DataMigrationServiceInner withVirtualSubnetId(String virtualSubnetId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataMigrationServiceProperties();
        }
        this.innerProperties().withVirtualSubnetId(virtualSubnetId);
        return this;
    }

    public String virtualNicId() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNicId();
    }

    public DataMigrationServiceInner withVirtualNicId(String virtualNicId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataMigrationServiceProperties();
        }
        this.innerProperties().withVirtualNicId(virtualNicId);
        return this;
    }

    public String autoStopDelay() {
        return this.innerProperties() == null ? null : this.innerProperties().autoStopDelay();
    }

    public DataMigrationServiceInner withAutoStopDelay(String autoStopDelay) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataMigrationServiceProperties();
        }
        this.innerProperties().withAutoStopDelay(autoStopDelay);
        return this;
    }

    public Boolean deleteResourcesOnStop() {
        return this.innerProperties() == null ? null : this.innerProperties().deleteResourcesOnStop();
    }

    public DataMigrationServiceInner withDeleteResourcesOnStop(Boolean deleteResourcesOnStop) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataMigrationServiceProperties();
        }
        this.innerProperties().withDeleteResourcesOnStop(deleteResourcesOnStop);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.systemData() != null) {
            this.systemData().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("etag", this.etag);
        jsonWriter.writeStringField("kind", this.kind);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        return jsonWriter.writeEndObject();
    }

    public static DataMigrationServiceInner fromJson(JsonReader jsonReader) throws IOException {
        return (DataMigrationServiceInner)((Object)jsonReader.readObject(reader -> {
            DataMigrationServiceInner deserializedDataMigrationServiceInner = new DataMigrationServiceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDataMigrationServiceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDataMigrationServiceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDataMigrationServiceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDataMigrationServiceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDataMigrationServiceInner.withTags(tags);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedDataMigrationServiceInner.etag = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedDataMigrationServiceInner.kind = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDataMigrationServiceInner.innerProperties = DataMigrationServiceProperties.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedDataMigrationServiceInner.sku = ServiceSku.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedDataMigrationServiceInner.systemData = SystemDataAutoGenerated.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataMigrationServiceInner;
        }));
    }
}

