/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.PowerQueryTypeProperties;
import com.azure.resourcemanager.datafactory.models.DataFlow;
import com.azure.resourcemanager.datafactory.models.DataFlowFolder;
import com.azure.resourcemanager.datafactory.models.PowerQuerySource;
import java.io.IOException;
import java.util.List;

public final class WranglingDataFlow
extends DataFlow {
    private String type = "WranglingDataFlow";
    private PowerQueryTypeProperties innerTypeProperties;

    @Override
    public String type() {
        return this.type;
    }

    PowerQueryTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public WranglingDataFlow withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public WranglingDataFlow withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    @Override
    public WranglingDataFlow withFolder(DataFlowFolder folder) {
        super.withFolder(folder);
        return this;
    }

    public List<PowerQuerySource> sources() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sources();
    }

    public WranglingDataFlow withSources(List<PowerQuerySource> sources) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PowerQueryTypeProperties();
        }
        this.innerTypeProperties().withSources(sources);
        return this;
    }

    public String script() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().script();
    }

    public WranglingDataFlow withScript(String script) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PowerQueryTypeProperties();
        }
        this.innerTypeProperties().withScript(script);
        return this;
    }

    public String documentLocale() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().documentLocale();
    }

    public WranglingDataFlow withDocumentLocale(String documentLocale) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PowerQueryTypeProperties();
        }
        this.innerTypeProperties().withDocumentLocale(documentLocale);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() != null) {
            this.innerTypeProperties().validate();
        }
        if (this.folder() != null) {
            this.folder().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        return jsonWriter.writeEndObject();
    }

    public static WranglingDataFlow fromJson(JsonReader jsonReader) throws IOException {
        return (WranglingDataFlow)jsonReader.readObject(reader -> {
            WranglingDataFlow deserializedWranglingDataFlow = new WranglingDataFlow();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedWranglingDataFlow.withDescription(reader.getString());
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedWranglingDataFlow.withAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedWranglingDataFlow.withFolder(DataFlowFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWranglingDataFlow.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedWranglingDataFlow.innerTypeProperties = PowerQueryTypeProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWranglingDataFlow;
        });
    }
}

