/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.WebAuthenticationType;
import com.azure.resourcemanager.datafactory.models.WebLinkedServiceTypeProperties;
import java.io.IOException;

public final class WebBasicAuthentication
extends WebLinkedServiceTypeProperties {
    private WebAuthenticationType authenticationType = WebAuthenticationType.BASIC;
    private Object username;
    private SecretBase password;
    private static final ClientLogger LOGGER = new ClientLogger(WebBasicAuthentication.class);

    @Override
    public WebAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public Object username() {
        return this.username;
    }

    public WebBasicAuthentication withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public WebBasicAuthentication withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    @Override
    public WebBasicAuthentication withUrl(Object url) {
        super.withUrl(url);
        return this;
    }

    @Override
    public void validate() {
        if (this.username() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property username in model WebBasicAuthentication"));
        }
        if (this.password() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property password in model WebBasicAuthentication"));
        }
        this.password().validate();
        if (this.url() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property url in model WebBasicAuthentication"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("url", this.url());
        jsonWriter.writeUntypedField("username", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        return jsonWriter.writeEndObject();
    }

    public static WebBasicAuthentication fromJson(JsonReader jsonReader) throws IOException {
        return (WebBasicAuthentication)jsonReader.readObject(reader -> {
            WebBasicAuthentication deserializedWebBasicAuthentication = new WebBasicAuthentication();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedWebBasicAuthentication.withUrl(reader.readUntyped());
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedWebBasicAuthentication.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedWebBasicAuthentication.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedWebBasicAuthentication.authenticationType = WebAuthenticationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebBasicAuthentication;
        });
    }
}

