/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.MetadataItem;
import com.azure.resourcemanager.datafactory.models.StoreWriteSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SftpWriteSettings
extends StoreWriteSettings {
    private String type = "SftpWriteSettings";
    private Object operationTimeout;
    private Object useTempFileRename;

    @Override
    public String type() {
        return this.type;
    }

    public Object operationTimeout() {
        return this.operationTimeout;
    }

    public SftpWriteSettings withOperationTimeout(Object operationTimeout) {
        this.operationTimeout = operationTimeout;
        return this;
    }

    public Object useTempFileRename() {
        return this.useTempFileRename;
    }

    public SftpWriteSettings withUseTempFileRename(Object useTempFileRename) {
        this.useTempFileRename = useTempFileRename;
        return this;
    }

    @Override
    public SftpWriteSettings withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public SftpWriteSettings withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public SftpWriteSettings withCopyBehavior(Object copyBehavior) {
        super.withCopyBehavior(copyBehavior);
        return this;
    }

    @Override
    public SftpWriteSettings withMetadata(List<MetadataItem> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public void validate() {
        if (this.metadata() != null) {
            this.metadata().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        if (this.copyBehavior() != null) {
            jsonWriter.writeUntypedField("copyBehavior", this.copyBehavior());
        }
        jsonWriter.writeArrayField("metadata", this.metadata(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        if (this.operationTimeout != null) {
            jsonWriter.writeUntypedField("operationTimeout", this.operationTimeout);
        }
        if (this.useTempFileRename != null) {
            jsonWriter.writeUntypedField("useTempFileRename", this.useTempFileRename);
        }
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SftpWriteSettings fromJson(JsonReader jsonReader) throws IOException {
        return (SftpWriteSettings)jsonReader.readObject(reader -> {
            SftpWriteSettings deserializedSftpWriteSettings = new SftpWriteSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSftpWriteSettings.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedSftpWriteSettings.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("copyBehavior".equals(fieldName)) {
                    deserializedSftpWriteSettings.withCopyBehavior(reader.readUntyped());
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List metadata = reader.readArray(reader1 -> MetadataItem.fromJson(reader1));
                    deserializedSftpWriteSettings.withMetadata(metadata);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSftpWriteSettings.type = reader.getString();
                    continue;
                }
                if ("operationTimeout".equals(fieldName)) {
                    deserializedSftpWriteSettings.operationTimeout = reader.readUntyped();
                    continue;
                }
                if ("useTempFileRename".equals(fieldName)) {
                    deserializedSftpWriteSettings.useTempFileRename = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSftpWriteSettings.withAdditionalProperties(additionalProperties);
            return deserializedSftpWriteSettings;
        });
    }
}

