/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySink;
import com.azure.resourcemanager.datafactory.models.SalesforceV2SinkWriteBehavior;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SalesforceServiceCloudV2Sink
extends CopySink {
    private String type = "SalesforceServiceCloudV2Sink";
    private SalesforceV2SinkWriteBehavior writeBehavior;
    private Object externalIdFieldName;
    private Object ignoreNullValues;

    @Override
    public String type() {
        return this.type;
    }

    public SalesforceV2SinkWriteBehavior writeBehavior() {
        return this.writeBehavior;
    }

    public SalesforceServiceCloudV2Sink withWriteBehavior(SalesforceV2SinkWriteBehavior writeBehavior) {
        this.writeBehavior = writeBehavior;
        return this;
    }

    public Object externalIdFieldName() {
        return this.externalIdFieldName;
    }

    public SalesforceServiceCloudV2Sink withExternalIdFieldName(Object externalIdFieldName) {
        this.externalIdFieldName = externalIdFieldName;
        return this;
    }

    public Object ignoreNullValues() {
        return this.ignoreNullValues;
    }

    public SalesforceServiceCloudV2Sink withIgnoreNullValues(Object ignoreNullValues) {
        this.ignoreNullValues = ignoreNullValues;
        return this;
    }

    @Override
    public SalesforceServiceCloudV2Sink withWriteBatchSize(Object writeBatchSize) {
        super.withWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public SalesforceServiceCloudV2Sink withWriteBatchTimeout(Object writeBatchTimeout) {
        super.withWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public SalesforceServiceCloudV2Sink withSinkRetryCount(Object sinkRetryCount) {
        super.withSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public SalesforceServiceCloudV2Sink withSinkRetryWait(Object sinkRetryWait) {
        super.withSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public SalesforceServiceCloudV2Sink withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public SalesforceServiceCloudV2Sink withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.writeBatchSize() != null) {
            jsonWriter.writeUntypedField("writeBatchSize", this.writeBatchSize());
        }
        if (this.writeBatchTimeout() != null) {
            jsonWriter.writeUntypedField("writeBatchTimeout", this.writeBatchTimeout());
        }
        if (this.sinkRetryCount() != null) {
            jsonWriter.writeUntypedField("sinkRetryCount", this.sinkRetryCount());
        }
        if (this.sinkRetryWait() != null) {
            jsonWriter.writeUntypedField("sinkRetryWait", this.sinkRetryWait());
        }
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("writeBehavior", this.writeBehavior == null ? null : this.writeBehavior.toString());
        if (this.externalIdFieldName != null) {
            jsonWriter.writeUntypedField("externalIdFieldName", this.externalIdFieldName);
        }
        if (this.ignoreNullValues != null) {
            jsonWriter.writeUntypedField("ignoreNullValues", this.ignoreNullValues);
        }
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SalesforceServiceCloudV2Sink fromJson(JsonReader jsonReader) throws IOException {
        return (SalesforceServiceCloudV2Sink)jsonReader.readObject(reader -> {
            SalesforceServiceCloudV2Sink deserializedSalesforceServiceCloudV2Sink = new SalesforceServiceCloudV2Sink();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("writeBatchSize".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Sink.withWriteBatchSize(reader.readUntyped());
                    continue;
                }
                if ("writeBatchTimeout".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Sink.withWriteBatchTimeout(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryCount".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Sink.withSinkRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryWait".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Sink.withSinkRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Sink.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Sink.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Sink.type = reader.getString();
                    continue;
                }
                if ("writeBehavior".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Sink.writeBehavior = SalesforceV2SinkWriteBehavior.fromString(reader.getString());
                    continue;
                }
                if ("externalIdFieldName".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Sink.externalIdFieldName = reader.readUntyped();
                    continue;
                }
                if ("ignoreNullValues".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Sink.ignoreNullValues = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSalesforceServiceCloudV2Sink.withAdditionalProperties(additionalProperties);
            return deserializedSalesforceServiceCloudV2Sink;
        });
    }
}

