/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.PrivateLinkResourceProperties;
import java.io.IOException;

public final class PrivateLinkResource
extends SubResource {
    private PrivateLinkResourceProperties properties;
    private String name;
    private String type;
    private String etag;

    public PrivateLinkResourceProperties properties() {
        return this.properties;
    }

    public PrivateLinkResource withProperties(PrivateLinkResourceProperties properties) {
        this.properties = properties;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String etag() {
        return this.etag;
    }

    public PrivateLinkResource withId(String id) {
        super.withId(id);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static PrivateLinkResource fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateLinkResource)((Object)jsonReader.readObject(reader -> {
            PrivateLinkResource deserializedPrivateLinkResource = new PrivateLinkResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPrivateLinkResource.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPrivateLinkResource.properties = PrivateLinkResourceProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPrivateLinkResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPrivateLinkResource.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedPrivateLinkResource.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateLinkResource;
        }));
    }
}

