/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.MapperAttributeReference;
import com.azure.resourcemanager.datafactory.models.MappingType;
import java.io.IOException;
import java.util.List;

public final class MapperAttributeMapping
implements JsonSerializable<MapperAttributeMapping> {
    private String name;
    private MappingType type;
    private String functionName;
    private String expression;
    private MapperAttributeReference attributeReference;
    private List<MapperAttributeReference> attributeReferences;

    public String name() {
        return this.name;
    }

    public MapperAttributeMapping withName(String name) {
        this.name = name;
        return this;
    }

    public MappingType type() {
        return this.type;
    }

    public MapperAttributeMapping withType(MappingType type) {
        this.type = type;
        return this;
    }

    public String functionName() {
        return this.functionName;
    }

    public MapperAttributeMapping withFunctionName(String functionName) {
        this.functionName = functionName;
        return this;
    }

    public String expression() {
        return this.expression;
    }

    public MapperAttributeMapping withExpression(String expression) {
        this.expression = expression;
        return this;
    }

    public MapperAttributeReference attributeReference() {
        return this.attributeReference;
    }

    public MapperAttributeMapping withAttributeReference(MapperAttributeReference attributeReference) {
        this.attributeReference = attributeReference;
        return this;
    }

    public List<MapperAttributeReference> attributeReferences() {
        return this.attributeReferences;
    }

    public MapperAttributeMapping withAttributeReferences(List<MapperAttributeReference> attributeReferences) {
        this.attributeReferences = attributeReferences;
        return this;
    }

    public void validate() {
        if (this.attributeReference() != null) {
            this.attributeReference().validate();
        }
        if (this.attributeReferences() != null) {
            this.attributeReferences().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("functionName", this.functionName);
        jsonWriter.writeStringField("expression", this.expression);
        jsonWriter.writeJsonField("attributeReference", (JsonSerializable)this.attributeReference);
        jsonWriter.writeArrayField("attributeReferences", this.attributeReferences, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MapperAttributeMapping fromJson(JsonReader jsonReader) throws IOException {
        return (MapperAttributeMapping)jsonReader.readObject(reader -> {
            MapperAttributeMapping deserializedMapperAttributeMapping = new MapperAttributeMapping();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedMapperAttributeMapping.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMapperAttributeMapping.type = MappingType.fromString(reader.getString());
                    continue;
                }
                if ("functionName".equals(fieldName)) {
                    deserializedMapperAttributeMapping.functionName = reader.getString();
                    continue;
                }
                if ("expression".equals(fieldName)) {
                    deserializedMapperAttributeMapping.expression = reader.getString();
                    continue;
                }
                if ("attributeReference".equals(fieldName)) {
                    deserializedMapperAttributeMapping.attributeReference = MapperAttributeReference.fromJson(reader);
                    continue;
                }
                if ("attributeReferences".equals(fieldName)) {
                    List attributeReferences;
                    deserializedMapperAttributeMapping.attributeReferences = attributeReferences = reader.readArray(reader1 -> MapperAttributeReference.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMapperAttributeMapping;
        });
    }
}

