/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopyActivityLogSettings;
import com.azure.resourcemanager.datafactory.models.LogLocationSettings;
import java.io.IOException;

public final class LogSettings
implements JsonSerializable<LogSettings> {
    private Object enableCopyActivityLog;
    private CopyActivityLogSettings copyActivityLogSettings;
    private LogLocationSettings logLocationSettings;
    private static final ClientLogger LOGGER = new ClientLogger(LogSettings.class);

    public Object enableCopyActivityLog() {
        return this.enableCopyActivityLog;
    }

    public LogSettings withEnableCopyActivityLog(Object enableCopyActivityLog) {
        this.enableCopyActivityLog = enableCopyActivityLog;
        return this;
    }

    public CopyActivityLogSettings copyActivityLogSettings() {
        return this.copyActivityLogSettings;
    }

    public LogSettings withCopyActivityLogSettings(CopyActivityLogSettings copyActivityLogSettings) {
        this.copyActivityLogSettings = copyActivityLogSettings;
        return this;
    }

    public LogLocationSettings logLocationSettings() {
        return this.logLocationSettings;
    }

    public LogSettings withLogLocationSettings(LogLocationSettings logLocationSettings) {
        this.logLocationSettings = logLocationSettings;
        return this;
    }

    public void validate() {
        if (this.copyActivityLogSettings() != null) {
            this.copyActivityLogSettings().validate();
        }
        if (this.logLocationSettings() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property logLocationSettings in model LogSettings"));
        }
        this.logLocationSettings().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("logLocationSettings", (JsonSerializable)this.logLocationSettings);
        if (this.enableCopyActivityLog != null) {
            jsonWriter.writeUntypedField("enableCopyActivityLog", this.enableCopyActivityLog);
        }
        jsonWriter.writeJsonField("copyActivityLogSettings", (JsonSerializable)this.copyActivityLogSettings);
        return jsonWriter.writeEndObject();
    }

    public static LogSettings fromJson(JsonReader jsonReader) throws IOException {
        return (LogSettings)jsonReader.readObject(reader -> {
            LogSettings deserializedLogSettings = new LogSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("logLocationSettings".equals(fieldName)) {
                    deserializedLogSettings.logLocationSettings = LogLocationSettings.fromJson(reader);
                    continue;
                }
                if ("enableCopyActivityLog".equals(fieldName)) {
                    deserializedLogSettings.enableCopyActivityLog = reader.readUntyped();
                    continue;
                }
                if ("copyActivityLogSettings".equals(fieldName)) {
                    deserializedLogSettings.copyActivityLogSettings = CopyActivityLogSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLogSettings;
        });
    }
}

