/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.GoogleBigQueryLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.GoogleBigQueryAuthenticationType;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class GoogleBigQueryLinkedService
extends LinkedService {
    private String type = "GoogleBigQuery";
    private GoogleBigQueryLinkedServiceTypeProperties innerTypeProperties = new GoogleBigQueryLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(GoogleBigQueryLinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    GoogleBigQueryLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public GoogleBigQueryLinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public GoogleBigQueryLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public GoogleBigQueryLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public GoogleBigQueryLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public GoogleBigQueryLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object project() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().project();
    }

    public GoogleBigQueryLinkedService withProject(Object project) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleBigQueryLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withProject(project);
        return this;
    }

    public Object additionalProjects() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().additionalProjects();
    }

    public GoogleBigQueryLinkedService withAdditionalProjects(Object additionalProjects) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleBigQueryLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAdditionalProjects(additionalProjects);
        return this;
    }

    public Object requestGoogleDriveScope() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().requestGoogleDriveScope();
    }

    public GoogleBigQueryLinkedService withRequestGoogleDriveScope(Object requestGoogleDriveScope) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleBigQueryLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withRequestGoogleDriveScope(requestGoogleDriveScope);
        return this;
    }

    public GoogleBigQueryAuthenticationType authenticationType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authenticationType();
    }

    public GoogleBigQueryLinkedService withAuthenticationType(GoogleBigQueryAuthenticationType authenticationType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleBigQueryLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthenticationType(authenticationType);
        return this;
    }

    public SecretBase refreshToken() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().refreshToken();
    }

    public GoogleBigQueryLinkedService withRefreshToken(SecretBase refreshToken) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleBigQueryLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withRefreshToken(refreshToken);
        return this;
    }

    public Object clientId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().clientId();
    }

    public GoogleBigQueryLinkedService withClientId(Object clientId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleBigQueryLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withClientId(clientId);
        return this;
    }

    public SecretBase clientSecret() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().clientSecret();
    }

    public GoogleBigQueryLinkedService withClientSecret(SecretBase clientSecret) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleBigQueryLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withClientSecret(clientSecret);
        return this;
    }

    public Object email() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().email();
    }

    public GoogleBigQueryLinkedService withEmail(Object email) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleBigQueryLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEmail(email);
        return this;
    }

    public Object keyFilePath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().keyFilePath();
    }

    public GoogleBigQueryLinkedService withKeyFilePath(Object keyFilePath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleBigQueryLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withKeyFilePath(keyFilePath);
        return this;
    }

    public Object trustedCertPath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().trustedCertPath();
    }

    public GoogleBigQueryLinkedService withTrustedCertPath(Object trustedCertPath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleBigQueryLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTrustedCertPath(trustedCertPath);
        return this;
    }

    public Object useSystemTrustStore() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().useSystemTrustStore();
    }

    public GoogleBigQueryLinkedService withUseSystemTrustStore(Object useSystemTrustStore) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleBigQueryLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUseSystemTrustStore(useSystemTrustStore);
        return this;
    }

    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public GoogleBigQueryLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleBigQueryLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model GoogleBigQueryLinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static GoogleBigQueryLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (GoogleBigQueryLinkedService)jsonReader.readObject(reader -> {
            GoogleBigQueryLinkedService deserializedGoogleBigQueryLinkedService = new GoogleBigQueryLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedGoogleBigQueryLinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedGoogleBigQueryLinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedGoogleBigQueryLinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedGoogleBigQueryLinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedGoogleBigQueryLinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedGoogleBigQueryLinkedService.innerTypeProperties = GoogleBigQueryLinkedServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGoogleBigQueryLinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedGoogleBigQueryLinkedService.withAdditionalProperties(additionalProperties);
            return deserializedGoogleBigQueryLinkedService;
        });
    }
}

