/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class Expression
implements JsonSerializable<Expression> {
    private final String type = "Expression";
    private String value;
    private static final ClientLogger LOGGER = new ClientLogger(Expression.class);

    public String type() {
        return this.type;
    }

    public String value() {
        return this.value;
    }

    public Expression withValue(String value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model Expression"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    public static Expression fromJson(JsonReader jsonReader) throws IOException {
        return (Expression)jsonReader.readObject(reader -> {
            Expression deserializedExpression = new Expression();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedExpression.value = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpression;
        });
    }
}

