/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.DatabricksSparkPythonActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class DatabricksSparkPythonActivity
extends ExecutionActivity {
    private String type = "DatabricksSparkPython";
    private DatabricksSparkPythonActivityTypeProperties innerTypeProperties = new DatabricksSparkPythonActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(DatabricksSparkPythonActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    DatabricksSparkPythonActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public DatabricksSparkPythonActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public DatabricksSparkPythonActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public DatabricksSparkPythonActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public DatabricksSparkPythonActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public DatabricksSparkPythonActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public DatabricksSparkPythonActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public DatabricksSparkPythonActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public DatabricksSparkPythonActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public Object pythonFile() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().pythonFile();
    }

    public DatabricksSparkPythonActivity withPythonFile(Object pythonFile) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DatabricksSparkPythonActivityTypeProperties();
        }
        this.innerTypeProperties().withPythonFile(pythonFile);
        return this;
    }

    public List<Object> parameters() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().parameters();
    }

    public DatabricksSparkPythonActivity withParameters(List<Object> parameters) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DatabricksSparkPythonActivityTypeProperties();
        }
        this.innerTypeProperties().withParameters(parameters);
        return this;
    }

    public List<Map<String, Object>> libraries() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().libraries();
    }

    public DatabricksSparkPythonActivity withLibraries(List<Map<String, Object>> libraries) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DatabricksSparkPythonActivityTypeProperties();
        }
        this.innerTypeProperties().withLibraries(libraries);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model DatabricksSparkPythonActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model DatabricksSparkPythonActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
        if (this.linkedServiceName() != null) {
            this.linkedServiceName().validate();
        }
        if (this.policy() != null) {
            this.policy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy());
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static DatabricksSparkPythonActivity fromJson(JsonReader jsonReader) throws IOException {
        return (DatabricksSparkPythonActivity)jsonReader.readObject(reader -> {
            DatabricksSparkPythonActivity deserializedDatabricksSparkPythonActivity = new DatabricksSparkPythonActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDatabricksSparkPythonActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDatabricksSparkPythonActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedDatabricksSparkPythonActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedDatabricksSparkPythonActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedDatabricksSparkPythonActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedDatabricksSparkPythonActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedDatabricksSparkPythonActivity.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedDatabricksSparkPythonActivity.withPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedDatabricksSparkPythonActivity.innerTypeProperties = DatabricksSparkPythonActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDatabricksSparkPythonActivity.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedDatabricksSparkPythonActivity.withAdditionalProperties(additionalProperties);
            return deserializedDatabricksSparkPythonActivity;
        });
    }
}

