/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.BlobTriggerTypeProperties;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.MultiplePipelineTrigger;
import com.azure.resourcemanager.datafactory.models.TriggerPipelineReference;
import com.azure.resourcemanager.datafactory.models.TriggerRuntimeState;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class BlobTrigger
extends MultiplePipelineTrigger {
    private String type = "BlobTrigger";
    private BlobTriggerTypeProperties innerTypeProperties = new BlobTriggerTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(BlobTrigger.class);

    @Override
    public String type() {
        return this.type;
    }

    BlobTriggerTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public BlobTrigger withPipelines(List<TriggerPipelineReference> pipelines) {
        super.withPipelines(pipelines);
        return this;
    }

    @Override
    public BlobTrigger withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public BlobTrigger withAnnotations(List<Object> annotations) {
        super.withAnnotations((List)annotations);
        return this;
    }

    public String folderPath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().folderPath();
    }

    public BlobTrigger withFolderPath(String folderPath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new BlobTriggerTypeProperties();
        }
        this.innerTypeProperties().withFolderPath(folderPath);
        return this;
    }

    public int maxConcurrency() {
        return this.innerTypeProperties() == null ? 0 : this.innerTypeProperties().maxConcurrency();
    }

    public BlobTrigger withMaxConcurrency(int maxConcurrency) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new BlobTriggerTypeProperties();
        }
        this.innerTypeProperties().withMaxConcurrency(maxConcurrency);
        return this;
    }

    public LinkedServiceReference linkedService() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().linkedService();
    }

    public BlobTrigger withLinkedService(LinkedServiceReference linkedService) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new BlobTriggerTypeProperties();
        }
        this.innerTypeProperties().withLinkedService(linkedService);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model BlobTrigger"));
        }
        this.innerTypeProperties().validate();
        if (this.pipelines() != null) {
            this.pipelines().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeArrayField("pipelines", this.pipelines(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static BlobTrigger fromJson(JsonReader jsonReader) throws IOException {
        return (BlobTrigger)jsonReader.readObject(reader -> {
            BlobTrigger deserializedBlobTrigger = new BlobTrigger();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedBlobTrigger.withDescription(reader.getString());
                    continue;
                }
                if ("runtimeState".equals(fieldName)) {
                    deserializedBlobTrigger.withRuntimeState(TriggerRuntimeState.fromString(reader.getString()));
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedBlobTrigger.withAnnotations(annotations);
                    continue;
                }
                if ("pipelines".equals(fieldName)) {
                    List pipelines = reader.readArray(reader1 -> TriggerPipelineReference.fromJson(reader1));
                    deserializedBlobTrigger.withPipelines(pipelines);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedBlobTrigger.innerTypeProperties = BlobTriggerTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBlobTrigger.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedBlobTrigger.withAdditionalProperties(additionalProperties);
            return deserializedBlobTrigger;
        });
    }
}

