/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySink;
import com.azure.resourcemanager.datafactory.models.MetadataItem;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class BlobSink
extends CopySink {
    private String type = "BlobSink";
    private Object blobWriterOverwriteFiles;
    private Object blobWriterDateTimeFormat;
    private Object blobWriterAddHeader;
    private Object copyBehavior;
    private List<MetadataItem> metadata;

    @Override
    public String type() {
        return this.type;
    }

    public Object blobWriterOverwriteFiles() {
        return this.blobWriterOverwriteFiles;
    }

    public BlobSink withBlobWriterOverwriteFiles(Object blobWriterOverwriteFiles) {
        this.blobWriterOverwriteFiles = blobWriterOverwriteFiles;
        return this;
    }

    public Object blobWriterDateTimeFormat() {
        return this.blobWriterDateTimeFormat;
    }

    public BlobSink withBlobWriterDateTimeFormat(Object blobWriterDateTimeFormat) {
        this.blobWriterDateTimeFormat = blobWriterDateTimeFormat;
        return this;
    }

    public Object blobWriterAddHeader() {
        return this.blobWriterAddHeader;
    }

    public BlobSink withBlobWriterAddHeader(Object blobWriterAddHeader) {
        this.blobWriterAddHeader = blobWriterAddHeader;
        return this;
    }

    public Object copyBehavior() {
        return this.copyBehavior;
    }

    public BlobSink withCopyBehavior(Object copyBehavior) {
        this.copyBehavior = copyBehavior;
        return this;
    }

    public List<MetadataItem> metadata() {
        return this.metadata;
    }

    public BlobSink withMetadata(List<MetadataItem> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public BlobSink withWriteBatchSize(Object writeBatchSize) {
        super.withWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public BlobSink withWriteBatchTimeout(Object writeBatchTimeout) {
        super.withWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public BlobSink withSinkRetryCount(Object sinkRetryCount) {
        super.withSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public BlobSink withSinkRetryWait(Object sinkRetryWait) {
        super.withSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public BlobSink withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public BlobSink withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.metadata() != null) {
            this.metadata().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.writeBatchSize() != null) {
            jsonWriter.writeUntypedField("writeBatchSize", this.writeBatchSize());
        }
        if (this.writeBatchTimeout() != null) {
            jsonWriter.writeUntypedField("writeBatchTimeout", this.writeBatchTimeout());
        }
        if (this.sinkRetryCount() != null) {
            jsonWriter.writeUntypedField("sinkRetryCount", this.sinkRetryCount());
        }
        if (this.sinkRetryWait() != null) {
            jsonWriter.writeUntypedField("sinkRetryWait", this.sinkRetryWait());
        }
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.blobWriterOverwriteFiles != null) {
            jsonWriter.writeUntypedField("blobWriterOverwriteFiles", this.blobWriterOverwriteFiles);
        }
        if (this.blobWriterDateTimeFormat != null) {
            jsonWriter.writeUntypedField("blobWriterDateTimeFormat", this.blobWriterDateTimeFormat);
        }
        if (this.blobWriterAddHeader != null) {
            jsonWriter.writeUntypedField("blobWriterAddHeader", this.blobWriterAddHeader);
        }
        if (this.copyBehavior != null) {
            jsonWriter.writeUntypedField("copyBehavior", this.copyBehavior);
        }
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static BlobSink fromJson(JsonReader jsonReader) throws IOException {
        return (BlobSink)jsonReader.readObject(reader -> {
            BlobSink deserializedBlobSink = new BlobSink();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("writeBatchSize".equals(fieldName)) {
                    deserializedBlobSink.withWriteBatchSize(reader.readUntyped());
                    continue;
                }
                if ("writeBatchTimeout".equals(fieldName)) {
                    deserializedBlobSink.withWriteBatchTimeout(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryCount".equals(fieldName)) {
                    deserializedBlobSink.withSinkRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryWait".equals(fieldName)) {
                    deserializedBlobSink.withSinkRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedBlobSink.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedBlobSink.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBlobSink.type = reader.getString();
                    continue;
                }
                if ("blobWriterOverwriteFiles".equals(fieldName)) {
                    deserializedBlobSink.blobWriterOverwriteFiles = reader.readUntyped();
                    continue;
                }
                if ("blobWriterDateTimeFormat".equals(fieldName)) {
                    deserializedBlobSink.blobWriterDateTimeFormat = reader.readUntyped();
                    continue;
                }
                if ("blobWriterAddHeader".equals(fieldName)) {
                    deserializedBlobSink.blobWriterAddHeader = reader.readUntyped();
                    continue;
                }
                if ("copyBehavior".equals(fieldName)) {
                    deserializedBlobSink.copyBehavior = reader.readUntyped();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List metadata;
                    deserializedBlobSink.metadata = metadata = reader.readArray(reader1 -> MetadataItem.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedBlobSink.withAdditionalProperties(additionalProperties);
            return deserializedBlobSink;
        });
    }
}

