/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class AzureKeyVaultSecretReference
extends SecretBase {
    private String type = "AzureKeyVaultSecret";
    private LinkedServiceReference store;
    private Object secretName;
    private Object secretVersion;
    private static final ClientLogger LOGGER = new ClientLogger(AzureKeyVaultSecretReference.class);

    @Override
    public String type() {
        return this.type;
    }

    public LinkedServiceReference store() {
        return this.store;
    }

    public AzureKeyVaultSecretReference withStore(LinkedServiceReference store) {
        this.store = store;
        return this;
    }

    public Object secretName() {
        return this.secretName;
    }

    public AzureKeyVaultSecretReference withSecretName(Object secretName) {
        this.secretName = secretName;
        return this;
    }

    public Object secretVersion() {
        return this.secretVersion;
    }

    public AzureKeyVaultSecretReference withSecretVersion(Object secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

    @Override
    public void validate() {
        if (this.store() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property store in model AzureKeyVaultSecretReference"));
        }
        this.store().validate();
        if (this.secretName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property secretName in model AzureKeyVaultSecretReference"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("store", (JsonSerializable)this.store);
        jsonWriter.writeUntypedField("secretName", this.secretName);
        jsonWriter.writeStringField("type", this.type);
        if (this.secretVersion != null) {
            jsonWriter.writeUntypedField("secretVersion", this.secretVersion);
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureKeyVaultSecretReference fromJson(JsonReader jsonReader) throws IOException {
        return (AzureKeyVaultSecretReference)jsonReader.readObject(reader -> {
            AzureKeyVaultSecretReference deserializedAzureKeyVaultSecretReference = new AzureKeyVaultSecretReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("store".equals(fieldName)) {
                    deserializedAzureKeyVaultSecretReference.store = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("secretName".equals(fieldName)) {
                    deserializedAzureKeyVaultSecretReference.secretName = reader.readUntyped();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureKeyVaultSecretReference.type = reader.getString();
                    continue;
                }
                if ("secretVersion".equals(fieldName)) {
                    deserializedAzureKeyVaultSecretReference.secretVersion = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureKeyVaultSecretReference;
        });
    }
}

