/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.AzureDatabricksLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AzureDatabricksLinkedService
extends LinkedService {
    private String type = "AzureDatabricks";
    private AzureDatabricksLinkedServiceTypeProperties innerTypeProperties = new AzureDatabricksLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(AzureDatabricksLinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    AzureDatabricksLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AzureDatabricksLinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public AzureDatabricksLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public AzureDatabricksLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AzureDatabricksLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public AzureDatabricksLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object domain() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().domain();
    }

    public AzureDatabricksLinkedService withDomain(Object domain) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDatabricksLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withDomain(domain);
        return this;
    }

    public SecretBase accessToken() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().accessToken();
    }

    public AzureDatabricksLinkedService withAccessToken(SecretBase accessToken) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDatabricksLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAccessToken(accessToken);
        return this;
    }

    public Object authentication() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authentication();
    }

    public AzureDatabricksLinkedService withAuthentication(Object authentication) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDatabricksLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthentication(authentication);
        return this;
    }

    public Object workspaceResourceId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().workspaceResourceId();
    }

    public AzureDatabricksLinkedService withWorkspaceResourceId(Object workspaceResourceId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDatabricksLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withWorkspaceResourceId(workspaceResourceId);
        return this;
    }

    public Object existingClusterId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().existingClusterId();
    }

    public AzureDatabricksLinkedService withExistingClusterId(Object existingClusterId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDatabricksLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withExistingClusterId(existingClusterId);
        return this;
    }

    public Object instancePoolId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().instancePoolId();
    }

    public AzureDatabricksLinkedService withInstancePoolId(Object instancePoolId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDatabricksLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withInstancePoolId(instancePoolId);
        return this;
    }

    public Object newClusterVersion() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().newClusterVersion();
    }

    public AzureDatabricksLinkedService withNewClusterVersion(Object newClusterVersion) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDatabricksLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withNewClusterVersion(newClusterVersion);
        return this;
    }

    public Object newClusterNumOfWorker() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().newClusterNumOfWorker();
    }

    public AzureDatabricksLinkedService withNewClusterNumOfWorker(Object newClusterNumOfWorker) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDatabricksLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withNewClusterNumOfWorker(newClusterNumOfWorker);
        return this;
    }

    public Object newClusterNodeType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().newClusterNodeType();
    }

    public AzureDatabricksLinkedService withNewClusterNodeType(Object newClusterNodeType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDatabricksLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withNewClusterNodeType(newClusterNodeType);
        return this;
    }

    public Map<String, Object> newClusterSparkConf() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().newClusterSparkConf();
    }

    public AzureDatabricksLinkedService withNewClusterSparkConf(Map<String, Object> newClusterSparkConf) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDatabricksLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withNewClusterSparkConf(newClusterSparkConf);
        return this;
    }

    public Map<String, Object> newClusterSparkEnvVars() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().newClusterSparkEnvVars();
    }

    public AzureDatabricksLinkedService withNewClusterSparkEnvVars(Map<String, Object> newClusterSparkEnvVars) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDatabricksLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withNewClusterSparkEnvVars(newClusterSparkEnvVars);
        return this;
    }

    public Map<String, Object> newClusterCustomTags() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().newClusterCustomTags();
    }

    public AzureDatabricksLinkedService withNewClusterCustomTags(Map<String, Object> newClusterCustomTags) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDatabricksLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withNewClusterCustomTags(newClusterCustomTags);
        return this;
    }

    public Object newClusterLogDestination() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().newClusterLogDestination();
    }

    public AzureDatabricksLinkedService withNewClusterLogDestination(Object newClusterLogDestination) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDatabricksLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withNewClusterLogDestination(newClusterLogDestination);
        return this;
    }

    public Object newClusterDriverNodeType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().newClusterDriverNodeType();
    }

    public AzureDatabricksLinkedService withNewClusterDriverNodeType(Object newClusterDriverNodeType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDatabricksLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withNewClusterDriverNodeType(newClusterDriverNodeType);
        return this;
    }

    public Object newClusterInitScripts() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().newClusterInitScripts();
    }

    public AzureDatabricksLinkedService withNewClusterInitScripts(Object newClusterInitScripts) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDatabricksLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withNewClusterInitScripts(newClusterInitScripts);
        return this;
    }

    public Object newClusterEnableElasticDisk() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().newClusterEnableElasticDisk();
    }

    public AzureDatabricksLinkedService withNewClusterEnableElasticDisk(Object newClusterEnableElasticDisk) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDatabricksLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withNewClusterEnableElasticDisk(newClusterEnableElasticDisk);
        return this;
    }

    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public AzureDatabricksLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDatabricksLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    public Object policyId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().policyId();
    }

    public AzureDatabricksLinkedService withPolicyId(Object policyId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDatabricksLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPolicyId(policyId);
        return this;
    }

    public CredentialReference credential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().credential();
    }

    public AzureDatabricksLinkedService withCredential(CredentialReference credential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDatabricksLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCredential(credential);
        return this;
    }

    public Object dataSecurityMode() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().dataSecurityMode();
    }

    public AzureDatabricksLinkedService withDataSecurityMode(Object dataSecurityMode) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDatabricksLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withDataSecurityMode(dataSecurityMode);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model AzureDatabricksLinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureDatabricksLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AzureDatabricksLinkedService)jsonReader.readObject(reader -> {
            AzureDatabricksLinkedService deserializedAzureDatabricksLinkedService = new AzureDatabricksLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureDatabricksLinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureDatabricksLinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedService.innerTypeProperties = AzureDatabricksLinkedServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureDatabricksLinkedService.withAdditionalProperties(additionalProperties);
            return deserializedAzureDatabricksLinkedService;
        });
    }
}

