/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetLocation;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AzureBlobFSLocation
extends DatasetLocation {
    private String type = "AzureBlobFSLocation";
    private Object fileSystem;

    @Override
    public String type() {
        return this.type;
    }

    public Object fileSystem() {
        return this.fileSystem;
    }

    public AzureBlobFSLocation withFileSystem(Object fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    @Override
    public AzureBlobFSLocation withFolderPath(Object folderPath) {
        super.withFolderPath(folderPath);
        return this;
    }

    @Override
    public AzureBlobFSLocation withFileName(Object fileName) {
        super.withFileName(fileName);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.folderPath() != null) {
            jsonWriter.writeUntypedField("folderPath", this.folderPath());
        }
        if (this.fileName() != null) {
            jsonWriter.writeUntypedField("fileName", this.fileName());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.fileSystem != null) {
            jsonWriter.writeUntypedField("fileSystem", this.fileSystem);
        }
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobFSLocation fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobFSLocation)jsonReader.readObject(reader -> {
            AzureBlobFSLocation deserializedAzureBlobFSLocation = new AzureBlobFSLocation();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("folderPath".equals(fieldName)) {
                    deserializedAzureBlobFSLocation.withFolderPath(reader.readUntyped());
                    continue;
                }
                if ("fileName".equals(fieldName)) {
                    deserializedAzureBlobFSLocation.withFileName(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureBlobFSLocation.type = reader.getString();
                    continue;
                }
                if ("fileSystem".equals(fieldName)) {
                    deserializedAzureBlobFSLocation.fileSystem = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureBlobFSLocation.withAdditionalProperties(additionalProperties);
            return deserializedAzureBlobFSLocation;
        });
    }
}

