/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.Activity;
import com.azure.resourcemanager.datafactory.models.Expression;
import com.azure.resourcemanager.datafactory.models.SwitchCase;
import java.io.IOException;
import java.util.List;

public final class SwitchActivityTypeProperties
implements JsonSerializable<SwitchActivityTypeProperties> {
    private Expression on;
    private List<SwitchCase> cases;
    private List<Activity> defaultActivities;
    private static final ClientLogger LOGGER = new ClientLogger(SwitchActivityTypeProperties.class);

    public Expression on() {
        return this.on;
    }

    public SwitchActivityTypeProperties withOn(Expression on) {
        this.on = on;
        return this;
    }

    public List<SwitchCase> cases() {
        return this.cases;
    }

    public SwitchActivityTypeProperties withCases(List<SwitchCase> cases) {
        this.cases = cases;
        return this;
    }

    public List<Activity> defaultActivities() {
        return this.defaultActivities;
    }

    public SwitchActivityTypeProperties withDefaultActivities(List<Activity> defaultActivities) {
        this.defaultActivities = defaultActivities;
        return this;
    }

    public void validate() {
        if (this.on() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property on in model SwitchActivityTypeProperties"));
        }
        this.on().validate();
        if (this.cases() != null) {
            this.cases().forEach(e -> e.validate());
        }
        if (this.defaultActivities() != null) {
            this.defaultActivities().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("on", (JsonSerializable)this.on);
        jsonWriter.writeArrayField("cases", this.cases, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("defaultActivities", this.defaultActivities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SwitchActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SwitchActivityTypeProperties)jsonReader.readObject(reader -> {
            SwitchActivityTypeProperties deserializedSwitchActivityTypeProperties = new SwitchActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("on".equals(fieldName)) {
                    deserializedSwitchActivityTypeProperties.on = Expression.fromJson(reader);
                    continue;
                }
                if ("cases".equals(fieldName)) {
                    List cases;
                    deserializedSwitchActivityTypeProperties.cases = cases = reader.readArray(reader1 -> SwitchCase.fromJson(reader1));
                    continue;
                }
                if ("defaultActivities".equals(fieldName)) {
                    List defaultActivities;
                    deserializedSwitchActivityTypeProperties.defaultActivities = defaultActivities = reader.readArray(reader1 -> Activity.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSwitchActivityTypeProperties;
        });
    }
}

