/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.ScriptActivityScriptBlock;
import com.azure.resourcemanager.datafactory.models.ScriptActivityTypePropertiesLogSettings;
import java.io.IOException;
import java.util.List;

public final class ScriptActivityTypeProperties
implements JsonSerializable<ScriptActivityTypeProperties> {
    private Object scriptBlockExecutionTimeout;
    private List<ScriptActivityScriptBlock> scripts;
    private ScriptActivityTypePropertiesLogSettings logSettings;
    private Object returnMultistatementResult;

    public Object scriptBlockExecutionTimeout() {
        return this.scriptBlockExecutionTimeout;
    }

    public ScriptActivityTypeProperties withScriptBlockExecutionTimeout(Object scriptBlockExecutionTimeout) {
        this.scriptBlockExecutionTimeout = scriptBlockExecutionTimeout;
        return this;
    }

    public List<ScriptActivityScriptBlock> scripts() {
        return this.scripts;
    }

    public ScriptActivityTypeProperties withScripts(List<ScriptActivityScriptBlock> scripts) {
        this.scripts = scripts;
        return this;
    }

    public ScriptActivityTypePropertiesLogSettings logSettings() {
        return this.logSettings;
    }

    public ScriptActivityTypeProperties withLogSettings(ScriptActivityTypePropertiesLogSettings logSettings) {
        this.logSettings = logSettings;
        return this;
    }

    public Object returnMultistatementResult() {
        return this.returnMultistatementResult;
    }

    public ScriptActivityTypeProperties withReturnMultistatementResult(Object returnMultistatementResult) {
        this.returnMultistatementResult = returnMultistatementResult;
        return this;
    }

    public void validate() {
        if (this.scripts() != null) {
            this.scripts().forEach(e -> e.validate());
        }
        if (this.logSettings() != null) {
            this.logSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.scriptBlockExecutionTimeout != null) {
            jsonWriter.writeUntypedField("scriptBlockExecutionTimeout", this.scriptBlockExecutionTimeout);
        }
        jsonWriter.writeArrayField("scripts", this.scripts, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("logSettings", (JsonSerializable)this.logSettings);
        if (this.returnMultistatementResult != null) {
            jsonWriter.writeUntypedField("returnMultistatementResult", this.returnMultistatementResult);
        }
        return jsonWriter.writeEndObject();
    }

    public static ScriptActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ScriptActivityTypeProperties)jsonReader.readObject(reader -> {
            ScriptActivityTypeProperties deserializedScriptActivityTypeProperties = new ScriptActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scriptBlockExecutionTimeout".equals(fieldName)) {
                    deserializedScriptActivityTypeProperties.scriptBlockExecutionTimeout = reader.readUntyped();
                    continue;
                }
                if ("scripts".equals(fieldName)) {
                    List scripts;
                    deserializedScriptActivityTypeProperties.scripts = scripts = reader.readArray(reader1 -> ScriptActivityScriptBlock.fromJson(reader1));
                    continue;
                }
                if ("logSettings".equals(fieldName)) {
                    deserializedScriptActivityTypeProperties.logSettings = ScriptActivityTypePropertiesLogSettings.fromJson(reader);
                    continue;
                }
                if ("returnMultistatementResult".equals(fieldName)) {
                    deserializedScriptActivityTypeProperties.returnMultistatementResult = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScriptActivityTypeProperties;
        });
    }
}

